package WordList::ID::BIP39;

our $DATE = '2018-01-01'; # DATE
our $VERSION = '0.001'; # VERSION

use WordList;
our @ISA = qw(WordList);

our %STATS = ("avg_word_len",6.24609375,"num_words_contains_whitespace",0,"shortest_word_len",4,"num_words",1024,"num_words_contains_nonword_chars",0,"num_words_contains_unicode",0,"longest_word_len",13); # STATS

1;
# ABSTRACT: Indonesian (proposed) word list for BIP 39

=pod

=encoding UTF-8

=head1 NAME

WordList::ID::BIP39 - Indonesian (proposed) word list for BIP 39

=head1 VERSION

This document describes version 0.001 of WordList::ID::BIP39 (from Perl distribution WordList-ID-BIP39), released on 2018-01-01.

=head1 SYNOPSIS

 use WordList::ID::BIP39;

 my $wl = WordList::ID::BIP39->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 DESCRIPTION

This is the proposed Indonesian word list for BIP 39. The list was formed by
selecting the most common Indonesian words from Wikipedia (see
L<WordLists::ID::Common> repository) that are at least 4 characters long and are
not found in the other BIP 39 wordlists (L<EN|WordList::EN::BIP39>,
L<ES|WordList::ES::BIP39>, L<FR|WordList::FR::BIP39>,
L<FR|WordList::IT::BIP39>). Characteristics of this wordlist:

=over

=item * Selected from most common words (Wikipedia Indonesia corpus).

=item * At least 4 characters long.

=item * Words can be uniquely determined typing the first 4 characters.

=item * Words are not found in the other languages' BIP wordlist, so language detection is easy.

=back

=head1 STATISTICS

 +----------------------------------+------------+
 | key                              | value      |
 +----------------------------------+------------+
 | avg_word_len                     | 6.24609375 |
 | longest_word_len                 | 13         |
 | num_words                        | 1024       |
 | num_words_contains_nonword_chars | 0          |
 | num_words_contains_unicode       | 0          |
 | num_words_contains_whitespace    | 0          |
 | shortest_word_len                | 4          |
 +----------------------------------+------------+

The statistics is available in the C<%STATS> package variable.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-ID-BIP39>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-ID-BIP39>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-ID-BIP39>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

About BIP 39: L<https://github.com/bitcoin/bips/blob/master/bip-0039.mediawiki>

About BIPs (Bitcoin Improvement Proposals): L<https://en.bitcoin.it/wiki/Bitcoin_Improvement_Proposals>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut

__DATA__
abad
acara
adalah
adanya
adat
adegan
adik
administratif
agak
agama
agar
agen
agresif
ahli
ajang
ajaran
akan
akhir
akibat
aksara
akses
aksi
aktif
aktor
aktris
akun
alam
alasan
alat
alias
alih
aliran
alternatif
aman
anak
analisis
ancaman
anda
anggota
angin
angka
animasi
anjing
antara
anti
apabila
apakah
apapun
aplikasi
arah
armada
arsip
artikel
arus
asal
asam
asing
asli
aspek
asteroid
atas
atau
aturan
awal
ayahnya
ayam
ayat
babak
badan
bagaimana
bagian
bagus
bahasa
bahkan
bahwa
baik
bakar
balapan
balik
band
bangsa
bank
bantuan
banyak
barat
baris
baru
basis
batas
batu
bawah
bayi
bebas
beberapa
beda
begitu
bekas
bekerja
belakang
belum
benar
bencana
bendera
bentuk
berada
berbagai
berdasarkan
berfungsi
bergabung
berhasil
berikut
berjudul
berkembang
berlangsung
bermain
bernama
beroperasi
berperan
bersama
bertemu
berubah
bervariasi
berwarna
beserta
besi
biasanya
biaya
bidang
bila
binatang
bintang
biru
bisa
bisnis
bita
blokir
boleh
buah
buatan
budaya
bukan
bukit
bukti
buku
bulan
bulu
bumi
bunga
burung
cabang
cahaya
calon
campuran
candi
catatan
cenderung
cepat
cerita
cetak
ciri
cocok
contoh
cucu
cukup
daerah
daftar
daging
dahulu
dalam
damai
dampak
dana
dapat
darah
dari
dasar
data
daun
daya
debut
dekat
delapan
demikian
dengan
depan
desa
detik
dewasa
diadakan
diakses
dialek
diambil
dianggap
diatur
dibangun
diberikan
dibintangi
dibuat
dicatat
diciptakan
didasarkan
didirikan
didukung
digantikan
digunakan
dihasilkan
diikuti
diisi
dijadikan
dijual
dikatakan
dikenal
dikirim
dikuasai
dilakukan
dilengkapi
dilihat
diluncurkan
dimana
dimensi
dimiliki
dimulai
dinamakan
dinding
dingin
dinyatakan
dioperasikan
dipakai
diperkirakan
dipimpin
diproduksi
dirancang
diresmikan
diri
disajikan
disebut
disingkat
diskusi
distrik
disutradarai
ditayangkan
ditebang
ditinjau
ditulis
diubah
diumumkan
divisi
diyakini
dokter
dokumen
dosa
duduk
dukungan
dulu
dunia
dusun
edisi
efek
ekonomi
ekor
eksekutif
elektronik
elemen
emas
empat
enam
energi
etnis
faktor
famili
fasilitas
fiksi
filum
fisik
fitur
fokus
format
fungsi
gabungan
gadis
gagal
gambar
ganda
gangguan
garis
gaya
gedung
gelar
gelombang
generasi
genus
gerakan
gerbang
gereja
gitar
global
golongan
grup
gubernur
gugur
guna
gunung
guru
hadir
halaman
halnya
halus
hampir
hanya
harapan
harga
hari
harta
harus
hasil
hati
hendak
hewan
hiburan
hidup
hijau
hilang
hingga
hitam
hubungan
hujan
hukum
huruf
hutan
ialah
ibadah
ibukota
ibunya
identitas
ikan
ikatan
iklan
ikut
ilmiah
ilmu
imam
indah
independen
individu
indonesia
industri
informasi
ingin
inilah
insting
internasional
inti
istana
istilah
istri
itulah
izin
jabatan
jadi
jahat
jalan
jalur
jangan
jantung
jarak
jaringan
jasa
jatuh
jauh
jawab
jelas
jembatan
jenderal
jenis
jika
jiwa
juara
judul
juga
jumlah
jurusan
justru
juta
kabar
kabel
kabupaten
kadang
kaisar
kakak
kaki
kalau
kali
kamar
kami
kampung
kamu
kanan
kantor
kapal
karakter
karena
karier
kartu
karya
kasih
kasus
kata
kategori
kaum
kawasan
kaya
kayu
keadaan
keagamaan
keamanan
kebanyakan
keberadaan
kebijakan
kebutuhan
kecamatan
kecepatan
kecil
kecuali
kedatangan
kedua
keempat
kegiatan
kehidupan
keinginan
kejadian
kejuaraan
kekaisaran
kekerasan
kekuatan
kelas
kelima
kelompok
keluarga
kemampuan
kembali
kemenangan
kemudian
kendaraan
kepada
kepercayaan
keputusan
kerajaan
kereta
kering
kerja
kertas
kerusakan
kesalahan
keseluruhan
kesulitan
ketika
keturunan
keuangan
keuntungan
khas
khusus
kilometer
kimia
kini
kira
kiri
kisah
kita
klasik
klub
kode
koleksi
kolonial
komandan
komersial
komputer
komunitas
kondisi
konflik
konsep
kontrak
kopi
korban
kosong
kota
kritikus
kualitas
kuat
kucing
kuda
kuil
kulit
kumpulan
kunci
kuning
kuno
kurang
kursi
laba
lagi
lagu
lahan
lahir
lain
laki
lakukan
lalat
lalu
lama
lambang
langsung
lanjut
lantai
lapangan
lapisan
laporan
latar
latihan
laut
lawan
layanan
lebar
lebih
legenda
lelaki
lemah
lembaga
lengkap
lepas
lewat
lihat
lingkungan
links
lintas
lirik
lisensi
listrik
logam
logo
lokal
lolos
lomba
luar
luas
lubang
luka
lukisan
lulus
lunak
macam
mahasiswa
majalah
maju
maka
makhluk
makin
makna
malam
mampu
manajemen
mantan
manusia
marah
marga
masalah
masih
masjid
maskapai
massa
masuk
masyarakat
matahari
materi
mati
maupun
mayoritas
medan
melalui
melewati
melihat
meluncurkan
memakan
membuat
memenangkan
memiliki
mempunyai
memulai
menarik
mencapai
mendapatkan
menerima
menggunakan
meninggal
menjadi
menolak
menteri
menunjukkan
menyebabkan
meraih
merdeka
mereka
merilis
merupakan
mesin
meskipun
metode
mewakili
militer
minggu
minuman
minyak
mirip
misalnya
misi
miskin
mobil
modern
mohon
molekul
muda
mulai
muncul
mundur
mungkin
murid
murni
musik
musuh
nabi
naik
nama
namun
nasional
naskah
nebula
negara
negeri
nilai
nominasi
nomor
nuklir
nusa
nyata
obat
objek
olahraga
oleh
operasi
orang
ordo
organisasi
otomatis
pabrik
pada
pagi
pajak
pakaian
paling
panas
pandangan
panggung
panjang
pantai
papan
para
parlemen
partai
pasangan
pasir
pasti
pasukan
patung
pecahan
pedagang
pegawai
pegunungan
pejabat
pekerjaan
pelayanan
pemain
pembangunan
pemerintah
pemimpin
pemuda
penampilan
pencarian
penduduk
penerbangan
pengguna
peningkatan
penjualan
penonton
pensiun
penting
penulis
penyanyi
perang
perbedaan
percaya
perdagangan
perempuan
pergi
perhatian
periode
perjalanan
perkembangan
perlu
permukaan
pernah
persen
pertama
perusahaan
perwira
pesawat
peserta
pesisir
pesta
petani
petunjuk
pihak
pikiran
pilihan
pimpinan
pindah
pintu
plat
pohon
poin
pokok
pola
politik
populer
posisi
potensi
prajurit
praktik
pranala
predator
presiden
pria
pribadi
primordial
prinsip
produksi
profesional
promosi
proses
provinsi
proyek
publik
puisi
pukul
pula
puluh
puncak
punya
pusat
pustaka
putaran
putih
putra
rahasia
raja
raksasa
rakyat
rambut
rangka
rasa
raya
reaksi
referensi
regional
rekaman
rekor
remaja
rencana
rendah
resmi
ribu
rilis
ringan
risiko
roda
ruang
rumah
rusak
rute
saat
saham
saja
sakit
salah
saling
saluran
sama
sambil
sampai
sana
sangat
sarana
sarjana
sastra
satelit
satu
saudara
saya
sebagai
sebesar
sebuah
secara
sedang
sederhana
sedikit
seekor
segala
segera
segi
sehari
sehingga
seiring
sejak
sejenis
sejumlah
sekarang
sekelompok
sekitar
sekolah
seksual
sektor
selama
selesai
seluruh
semakin
sembilan
sementara
seminggu
sempat
semua
senang
sendiri
sengaja
seni
senjata
senyawa
seorang
sepanjang
seperti
sepuluh
serangan
sering
serta
serupa
seseorang
sesuatu
setahun
setelah
setiap
setuju
sewaktu
siapa
siaran
sifat
signifikan
sikap
simbol
sinetron
singel
sini
sinyal
sipil
sisa
sisi
sistem
siswa
situs
skala
skor
sosial
spesies
spons
stadion
standar
stasiun
status
strategis
string
struktur
studi
suaminya
suara
suatu
suci
sudah
sudut
suhu
suka
sukses
suku
sulit
sumber
sungai
suntingan
supaya
surat
sutradara
swasta
syarat
tahap
tahta
tahun
takhta
takut
taman
tambahan
tampil
tamu
tanah
tanda
tanggal
tanpa
tapi
tari
tata
tayang
teater
tekanan
teknologi
teks
telah
televisi
telur
teman
tempat
tenaga
tengah
tentang
teori
tepat
tepi
terakhir
terbentuk
tercatat
terdapat
tergolong
terhadap
terjadi
terkenal
terletak
termasuk
ternyata
terpilih
tersebut
tertentu
terutama
tetapi
tewas
tiap
tiba
tidak
tidur
tiga
timur
tindakan
tinggi
tipe
titik
tokoh
topik
tradisional
transportasi
tuan
tubuh
tugas
tujuan
tulang
tulisan
tumbuh
tunggal
turnamen
turut
uang
ubah
udara
ujung
ukuran
ulama
ulang
ular
umat
umumnya
umur
undang
unik
universitas
unsur
untuk
upacara
upaya
urusan
urutan
usaha
usia
uskup
usulan
utama
utara
versi
vokal
wafat
wajah
wajib
wakil
waktu
walaupun
wali
wanita
warga
warna
wilayah
wisata
yaitu
yakni
yang
zaman
