package WordList::EN::CountryNames::SingleWord;

our $DATE = '2016-01-12'; # DATE
our $VERSION = '0.03'; # VERSION

use WordList;
our @ISA = qw(WordList);

1;
# ABSTRACT: English country names (single-word entries only)




=pod

=encoding UTF-8

=head1 NAME

WordList::EN::CountryNames::SingleWord - English country names (single-word entries only)

=head1 VERSION

This document describes version 0.03 of WordList::EN::CountryNames::SingleWord (from Perl distribution WordList-EN-CountryNames), released on 2016-01-12.

=head1 SYNOPSIS

 use WordList::EN::CountryNames::SingleWord;

 my $wl = WordList::EN::CountryNames::SingleWord->new;

 # Pick a (or several) random word(s) from the list
 my $word = $wl->pick;
 my @words = $wl->pick(3);

 # Check if a word exists in the list
 if ($wl->word_exists('foo')) { ... }

 # Call a callback for each word
 $wl->each_word(sub { my $word = shift; ... });

 # Get all the words
 my @all_words = $wl->all_words;

=head1 SEE ALSO

Converted from L<Games::Word::Wordlist::CountrySingleWord> 0.02.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/WordList-EN-CountryNames>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-WordList-EN-CountryNames>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=WordList-EN-CountryNames>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut


__DATA__
afghanistan
albania
algeria
andorra
angola
anguilla
antarctica
argentina
armenia
aruba
australia
austria
azerbaijan
bahamas
bahrain
bangladesh
barbados
belarus
belgium
belize
benin
bermuda
bhutan
bolivia
botswana
brazil
brunei
bulgaria
burma
burundi
cambodia
cameroon
canada
chad
chile
china
colombia
comoros
congo
croatia
cuba
curacao
cyprus
denmark
djibouti
dominica
ecuador
egypt
eritrea
estonia
ethiopia
fiji
finland
france
gabon
gambia
georgia
germany
ghana
gibraltar
greece
greenland
grenada
guadeloupe
guam
guatemala
guernsey
guinea
guyana
haiti
honduras
hungary
iceland
india
indonesia
iran
iraq
ireland
israel
italy
jamaica
japan
jersey
jordan
kazakstan
kenya
kiribati
kuwait
kyrgyzstan
latvia
lebanon
lesotho
liberia
libya
liechtenstein
lithuania
luxembourg
macao
macedonia
madagascar
malawi
malaysia
maldives
mali
malta
martinique
mauritania
mauritius
mayotte
mexico
monaco
mongolia
montenegro
montserrat
morocco
mozambique
namibia
nauru
nepal
netherlands
nicaragua
niger
nigeria
niue
norway
oman
pakistan
palau
panama
paraguay
peru
philippines
pitcairn
poland
portugal
qatar
reunion
romania
rwanda
samoa
senegal
serbia
seychelles
singapore
slovakia
slovenia
somalia
spain
sudan
suriname
swaziland
sweden
switzerland
syria
taiwan
tajikistan
thailand
togo
tokelau
tonga
tunisia
turkey
turkmenistan
tuvalu
uganda
uk
ukraine
uruguay
us
uzbekistan
vanuatu
vietnam
yemen
zambia
zimbabwe
