package Sah::Schema::negeven;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2020-03-02'; # DATE
our $DIST = 'Sah-Schemas-Int'; # DIST
our $VERSION = '0.073'; # VERSION

our $schema = ['negint', {
    summary => 'Negative even number',
    div_by => 2,
    examples => [
        {data=>-2, valid=>1},
        {data=>-1, valid=>0},
    ],
}, {}];

1;
# ABSTRACT: Negative even number

__END__

=pod

=encoding UTF-8

=head1 NAME

Sah::Schema::negeven - Negative even number

=head1 VERSION

This document describes version 0.073 of Sah::Schema::negeven (from Perl distribution Sah-Schemas-Int), released on 2020-03-02.

=head1 SYNOPSIS

Sample data:

 -2  # valid

 -1  # INVALID

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sah-Schemas-Int>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sah-Schemas-Int>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sah-Schemas-Int>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2020, 2018, 2017, 2016, 2014 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
