package Role::TinyCommons::Collection::Subscript;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2021-05-03'; # DATE
our $DIST = 'Role-TinyCommons-Collection'; # DIST
our $VERSION = '0.004'; # VERSION

use Role::Tiny;

### required methods

requires 'item_at';

1;
# ABSTRACT: Subscripting (key-ing) operation

__END__

=pod

=encoding UTF-8

=head1 NAME

Role::TinyCommons::Collection::Subscript - Subscripting (key-ing) operation

=head1 VERSION

This document describes version 0.004 of Role::TinyCommons::Collection::Subscript (from Perl distribution Role-TinyCommons-Collection), released on 2021-05-03.

=head1 SYNOPSIS

=head1 DESCRIPTION

This role is for collections that support subscripting operation: locating an
item via a single index a.k.a. key (an integer like in an array collection, or a
string like in a hash).

=head1 REQUIRED METHODS

=head2 get_item_at

Usage:

 my $item = $obj->get_item_at($subscript); # dies when not found

Return item at subscript C<$subscript>. Method must die when there is no item at
such subscript.

=head2 has_item_at

Usage:

 my $has_item = $obj->has_item_at($subscript); # => bool

Check whether the collection has item at subscript C<$subscript>.

=head2 get_all_subscripts

Usage:

 my @subscripts = $obj->get_all_subscripts;

Return all known subscripts or keys. Note that a specific order is not required.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Role-TinyCommons-Collection>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Role-TinyCommons-Collection>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://github.com/perlancar/perl-Role-TinyCommons-Collection/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
