package Data::Sah::Lang::zh_CN;

our $DATE = '2015-05-13'; # DATE
our $VERSION = '0.56'; # VERSION

use 5.010;
use strict;
use warnings;

use Tie::IxHash;

# currently incomplete

our %translations;
tie %translations, 'Tie::IxHash', (

    # punctuations

    q[ ], # inter-word boundary
    q[],

    q[, ],
    q[Ã¯Â¼Â],

    q[: ],
    q[Ã¯Â¼Â],

    q[. ],
    q[Ã£ÂÂ],

    q[(],
    q[Ã¯Â¼Â],

    q[)],
    q[Ã¯Â¼Â],

    # modal verbs

    q[must],
    q[Ã¥Â¿ÂÃ©Â¡Â»],

    q[must not],
    q[Ã¥Â¿ÂÃ©Â¡Â»Ã¤Â¸Â],

    q[should],
    q[Ã¥ÂºÂ],

    q[should not],
    q[Ã¥ÂºÂÃ¤Â¸Â],

    # field/fields/argument/arguments

    q[field],
    q[Ã¥Â­ÂÃ¦Â®Âµ],

    q[fields],
    q[Ã¥Â­ÂÃ¦Â®Âµ],

    q[argument],
    q[Ã¥ÂÂÃ¦ÂÂ°],

    q[arguments],
    q[Ã¥ÂÂÃ¦ÂÂ°],

    # multi

    q[%s and %s],
    q[%sÃ¥ÂÂ%s],

    q[%s or %s],
    q[%sÃ¦ÂÂ%s],

    q[one of %s],
    q[Ã¨Â¿ÂÃ¤ÂºÂÃ¥ÂÂ¼%sÃ¤Â¹ÂÃ¤Â¸Â],

    q[all of %s],
    q[Ã¦ÂÂÃ¦ÂÂÃ¨Â¿ÂÃ¤ÂºÂÃ¥ÂÂ¼%s],

    q[%(modal_verb)s satisfy all of the following],
    q[%(modal_verb)sÃ¦Â»Â¡Ã¨Â¶Â³Ã¦ÂÂÃ¦ÂÂÃ¨Â¿ÂÃ¤ÂºÂÃ¦ÂÂ¡Ã¤Â»Â¶],

    q[%(modal_verb)s satisfy one of the following],
    q[%(modal_verb)sÃ¦Â»Â¡Ã¨Â¶Â³Ã¨Â¿ÂÃ¤ÂºÂÃ¦ÂÂ¡Ã¤Â»Â¶Ã¤Â¹ÂÃ¤Â¸Â],

    q[%(modal_verb)s satisfy none of the following],
    q[%(modal_verb_neg)sÃ¦Â»Â¡Ã¨Â¶Â³Ã¦ÂÂÃ¦ÂÂÃ¨Â¿ÂÃ¤ÂºÂÃ¦ÂÂ¡Ã¤Â»Â¶],

    # type: BaseType

    # type: Sortable

    # type: Comparable

    # type: HasElems

    # type: num

    # type: int

    q[integer],
    q[Ã¦ÂÂ´Ã¦ÂÂ°],

    q[integers],
    q[Ã¦ÂÂ´Ã¦ÂÂ°],

    q[%(modal_verb)s be divisible by %s],
    q[%(modal_verb)sÃ¨Â¢Â«%sÃ¦ÂÂ´Ã©ÂÂ¤],

    q[%(modal_verb)s leave a remainder of %2$s when divided by %1$s],
    q[Ã©ÂÂ¤Ã¤Â»Â¥%1$sÃ¦ÂÂ¶Ã¤Â½ÂÃ¦ÂÂ°%(modal_verb)sÃ¤Â¸Âº%2$s],

);

1;
# ABSTRACT: zh_CN locale

__END__

=pod

=encoding UTF-8

=head1 NAME

Data::Sah::Lang::zh_CN - zh_CN locale

=head1 VERSION

This document describes version 0.56 of Data::Sah::Lang::zh_CN (from Perl distribution Perinci-CmdLine-Any-Lumped version 0.06), released on 2015-05-13.

=for Pod::Coverage .+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Data-Sah>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Data-Sah>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Data-Sah>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
