package Nodejs::Util;

our $DATE = '2016-05-17'; # DATE
our $VERSION = '0.003'; # VERSION

use 5.010001;
use strict;
use warnings;

use Exporter qw(import);
our @EXPORT_OK = qw(get_nodejs_path);

sub get_nodejs_path {
    require File::Which;

    my $path;
    for my $name (qw/nodejs node/) {
        $path = File::Which::which($name);
        next unless $path;

        # check if it's really nodejs
        my $cmd = "$path -e 'console.log(1+1)'";
        my $out = `$cmd`;
        if ($out =~ /\A2\n?\z/) {
            return $path;
        } else {
            #say "D:Output of $cmd: $out";
        }
    }
    return undef;
}

1;
# ABSTRACT: Utilities related to Node.js

__END__

=pod

=encoding UTF-8

=head1 NAME

Nodejs::Util - Utilities related to Node.js

=head1 VERSION

This document describes version 0.003 of Nodejs::Util (from Perl distribution Nodejs-Util), released on 2016-05-17.

=head1 FUNCTIONS

None exported by default.

=head2 get_nodejs_path() => str

Check availability of the Node.js executable in the PATH. Return the path to
executable or undef if none is available. Node.js is usually installed as 'node'
or 'nodejs'.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Nodejs-Util>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Nodejs-Util>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Nodejs-Util>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
