package Function::Fallback::CoreOrPP::ScalarUtilNumeric;

our $DATE = '2015-04-12'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

require Exporter;
our @ISA       = qw(Exporter);
our @EXPORT_OK = qw(
                       isint
                       isnum
                       isnan
                       isinf
                       isneg
                       isfloat
               );

sub isint {
    local $_ = shift;
    return 0 unless defined;
    return 1 if /\A[+-]?(?:0|[1-9][0-9]*)\z/;
    0;
}

sub isnan($) {
    local $_ = shift;
    return 0 unless defined;
    return 1 if /\A\s*[+-]?nan\s*\z/i;
    0;
}

sub isinf($) {
    local $_ = shift;
    return 0 unless defined;
    return 1 if /\A\s*[+-]?inf(?:inity)?\s*\z/i;
    0;
}

sub isneg($) {
    local $_ = shift;
    return 0 unless defined;
    return 1 if /\A\s*-/;
    0;
}

sub isnum($) {
    goto &isfloat;
}

sub isfloat($) {
    local $_ = shift;
    return 0 unless defined;
    return 1 if /\A[+-]?(?:0|[1-9][0-9]*)(?:\.[0-9]+)?(?:[eE][+-]?[0-9]+)?\z/;
    return 1 if isnan($_) || isinf($_);
    0;
}

1;
# ABSTRACT: Pure-perl drop-in replacement/approximation of Scalar::Util::Numeric

__END__

=pod

=encoding UTF-8

=head1 NAME

Function::Fallback::CoreOrPP::ScalarUtilNumeric - Pure-perl drop-in replacement/approximation of Scalar::Util::Numeric

=head1 VERSION

This document describes version 0.01 of Function::Fallback::CoreOrPP::ScalarUtilNumeric (from Perl distribution Function-Fallback-CoreOrPP-ScalarUtilNumeric), released on 2015-04-12.

=head1 SYNOPSIS

=head1 DESCRIPTION

This module is written mainly for the convenience of L<Data::Sah>, as a drop-in
pure-perl replacement for the XS module L<Scalar::Util::Numeric>, in the case
when Data::Sah needs to generate code that uses PP modules instead of XS ones.

=head1 FUNCTIONS

=head2 isint

=head2 isfloat

=head2 isnum

=head2 isneg

=head2 isinf

=head2 isnan

=head1 SEE ALSO

L<Data::Sah>

L<Scalar::Util::Numeric>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Function-Fallback-CoreOrPP-ScalarUtilNumeric>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Function-Fallback-CoreOrPP-ScalarUtilNumeric>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Function-Fallback-CoreOrPP-ScalarUtilNumeric>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
