package Dist::Zilla::Role::Rinci::CheckDefinesMeta;

our $DATE = '2015-09-11'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use Moose::Role;

sub check_dist_defines_rinci_meta {
    no strict 'refs';

    my $self = shift;

    # cache result
    state $res;
    return $res if defined $res;

    my $files = $self->zilla->find_files(':InstallModules');

    local @INC = ("lib", @INC);
    $res = 0;
    for my $file (@$files) {
        my $name = $file->name;
        $name =~ s!\Alib/!!;
        require $name;
        my $pkg = $name; $pkg =~ s/\.pm\z//; $pkg =~ s!/!::!g;
        if (keys %{"$pkg\::SPEC"}) {
            $res = 1;
            last;
        }
    }

    $res;
}

no Moose::Role;
1;
# ABSTRACT: Role to check if dist defines Rinci metadata

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Role::Rinci::CheckDefinesMeta - Role to check if dist defines Rinci metadata

=head1 VERSION

This document describes version 0.01 of Dist::Zilla::Role::Rinci::CheckDefinesMeta (from Perl distribution Dist-Zilla-Role-Rinci-CheckDefinesMeta), released on 2015-09-11.

=head1 METHODS

=head2 $obj->check_dist_defines_rinci_meta => bool

Will return true if dist defines Rinci metadata. Currently this is checked via
loading all the module files and checking whether C<%SPEC> in the corresponding
package contains stuffs.

Scripts (and example or shared Perl code) are currently skipped, so if you
define Rinci metadata in those places this routine will not detect them.

=head1 SEE ALSO

L<Rinci>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Role-Rinci-CheckDefinesMeta>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Role-Rinci-CheckDefinesMeta>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Role-Rinci-CheckDefinesMeta>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
