package Complete::Args;

our $DATE = '2015-11-28'; # DATE
our $VERSION = '0.17'; # VERSION

use 5.010001;
use strict;
use warnings;

our %args = (
    word => {
        summary => 'Word to complete',
        schema => ['str', default=>''],
        pos=>0,
        req=>1,
    },
    ci => {
        summary => 'Whether to do case-insensitive search',
        schema => 'bool',
    },
    fuzzy => {
        summary => 'The level of fuzzy matching',
        schema => ['int*', min=>0],
    },
    map_case => {
        summary => 'Whether to treat _ (underscore) and - (dash) as the same',
        schema => 'bool',
    },
);

1;
# ABSTRACT: Common arguments for complete_* routines

__END__

=pod

=encoding UTF-8

=head1 NAME

Complete::Args - Common arguments for complete_* routines

=head1 VERSION

This document describes version 0.17 of Complete::Args (from Perl distribution Complete-Common), released on 2015-11-28.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Complete-Common>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Complete-Common>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Complete-Common>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
