package Bencher::Scenario::TimeDurationParse::parse_duration;

our $DATE = '2016-05-17'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark parse_duration()',
    participants => [
        {name => 'TDP' , fcall_template => 'Time::Duration::Parse::parse_duration(<str>)'},
        {name => 'TDPA', fcall_template => 'Time::Duration::Parse::AsHash::parse_duration(<str>)'},
    ],
    datasets => [
        {args => {'str@' => ['3h', '3 hours 4 minutes']}},
    ],
};

1;
# ABSTRACT: Benchmark parse_duration()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TimeDurationParse::parse_duration - Benchmark parse_duration()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::TimeDurationParse::parse_duration (from Perl distribution Bencher-Scenarios-TimeDurationParse), released on 2016-05-17.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TimeDurationParse::parse_duration

To run module startup overhead benchmark:

 % bencher --module-startup -m TimeDurationParse::parse_duration

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Time::Duration::Parse> 0.13

L<Time::Duration::Parse::AsHash> 0.10.2

=head1 BENCHMARK PARTICIPANTS

=over

=item * TDP (perl_code)

Function call template:

 Time::Duration::Parse::parse_duration(<str>)



=item * TDPA (perl_code)

Function call template:

 Time::Duration::Parse::AsHash::parse_duration(<str>)



=back

=head1 BENCHMARK DATASETS

=over

=item * ["3h","3 hours 4 minutes"]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m TimeDurationParse::parse_duration >>):

 +-------------+-------------------+-----------+-----------+------------+---------+---------+
 | participant | arg_str           | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+-------------------+-----------+-----------+------------+---------+---------+
 | TDPA        | 3 hours 4 minutes | 1.22e+05  | 8.18      | 1          | 3.1e-09 | 23      |
 | TDP         | 3 hours 4 minutes | 1.4e+05   | 7.1       | 1.2        | 1.3e-08 | 20      |
 | TDPA        | 3h                | 2e+05     | 5         | 1.6        | 6.7e-09 | 20      |
 | TDP         | 3h                | 2.7e+05   | 3.8       | 2.2        | 7.6e-09 | 24      |
 +-------------+-------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m TimeDurationParse::parse_duration --module-startup >>):

 +-------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                   | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +-------------------------------+-----------+------------------------+------------+---------+---------+
 | Time::Duration::Parse         | 11        | 6.6                    | 1          | 3.7e-05 | 22      |
 | Time::Duration::Parse::AsHash | 8.1       | 3.7                    | 1.4        | 4.9e-05 | 20      |
 | perl -e1 (baseline)           | 4.4       | 0                      | 2.5        | 3.9e-05 | 20      |
 +-------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

L<Time::Duration::Parse::AsHash> is expected to be slightly slower since it
needs to build and return a hashref instead of a single number.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TimeDurationParse>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TimeDurationParse>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TimeDurationParse>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
