package Bencher::Scenario::SortSub::naturally;

our $DATE = '2016-12-12'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

use List::Util qw(shuffle);
use Sort::Sub qw($naturally);

our $scenario = {
    summary => 'Benchmark natural sorting',
    modules => {
    },
    participants => [
        {
            name => 'Sort::Sub::naturally',
            module => 'Sort::Sub',
            code_template => 'sort $Bencher::Scenario::SortSub::naturally::naturally @{<data>}',
            result_is_list => 1,
        },
        {
            fcall_template => 'Sort::Naturally::nsort(@{<data>})',
            result_is_list => 1,
        },
    ],
    datasets => [
        { name=>'10items' , args=>{data=>[shuffle map { "track$_.mp3" } 1..10 ]} },
        { name=>'100items', args=>{data=>[shuffle map { "track$_.mp3" } 1..100]} },
    ],
};

1;
# ABSTRACT: Benchmark natural sorting

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SortSub::naturally - Benchmark natural sorting

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::SortSub::naturally (from Perl distribution Bencher-Scenarios-SortSub), released on 2016-12-12.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SortSub::naturally

To run module startup overhead benchmark:

 % bencher --module-startup -m SortSub::naturally

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Sort::Naturally> 1.03

L<Sort::Sub> 0.06

=head1 BENCHMARK PARTICIPANTS

=over

=item * Sort::Sub::naturally (perl_code)

Code template:

 sort $Bencher::Scenario::SortSub::naturally::naturally @{<data>}



=item * Sort::Naturally::nsort (perl_code)

Function call template:

 Sort::Naturally::nsort(@{<data>})



=back

=head1 BENCHMARK DATASETS

=over

=item * 10items

=item * 100items

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.5 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m SortSub::naturally >>):

 #table1#
 +------------------------+----------+-----------+-----------+------------+---------+---------+
 | participant            | dataset  | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------+----------+-----------+-----------+------------+---------+---------+
 | Sort::Naturally::nsort | 100items |       850 | 1200      |       1    | 2.2e-06 |      20 |
 | Sort::Naturally::nsort | 10items  |     17000 |   58      |      20    | 1.1e-07 |      20 |
 | Sort::Sub::naturally   | 100items |    247610 |    4.0386 |     290.05 | 1.1e-11 |      20 |
 | Sort::Sub::naturally   | 10items  |   2012000 |    0.497  |    2357    | 1.1e-11 |      20 |
 +------------------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m SortSub::naturally --module-startup >>):

 #table2#
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | participant         | proc_private_dirty_size (MB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | Sort::Naturally     | 0.82                         | 4.1                | 20             |       6.9 |                    4.4 |        1   | 3.7e-05 |      20 |
 | Sort::Sub           | 1.2                          | 4.6                | 20             |       4.3 |                    1.8 |        1.6 | 1.9e-05 |      21 |
 | perl -e1 (baseline) | 0.86                         | 4.3                | 20             |       2.5 |                    0   |        2.7 | 4.7e-06 |      20 |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-SortSub>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-SortSub>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-SortSub>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
