package Bencher::Scenario::PerinciSubValidateArgs::Overhead;

our $DATE = '2016-05-24'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

# initialize the validators
use Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV;
Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=>1, a2=>1);

our $scenario = {
    summary => 'Measure validation overhead',
    participants => [
        {
            name => 'none',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual+dsah',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'Rinci::Validate',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingRinciValidate::foo(a1=><a1>, a2=><a2>)',
            include_by_default => 0,
        },
        {
            name => 'PSV',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'Type::Tiny',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny::foo(a1=><a1>, a2=><a2>)',
        },
    ],
    datasets => [
        {args => {a1=>1, a2=>[1]}},
    ],
};

1;
# ABSTRACT: Measure validation overhead

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciSubValidateArgs::Overhead - Measure validation overhead

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::PerinciSubValidateArgs::Overhead (from Perl distribution Bencher-Scenarios-PerinciSubValidateArgs), released on 2016-05-24.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PerinciSubValidateArgs::Overhead

To run module startup overhead benchmark:

 % bencher --module-startup -m PerinciSubValidateArgs::Overhead

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny>

=head1 BENCHMARK PARTICIPANTS

=over

=item * none (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)



=item * manual (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)



=item * manual+dsah (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)



=item * Rinci::Validate (perl_code) (not included by default)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)



=item * PSV (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny::foo(a1=><a1>, a2=><a2>)



=item * Type::Tiny (perl_code)

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny>::foo



=back

=head1 BENCHMARK DATASETS

=over

=item * {a1=>1,a2=>[1]}

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m PerinciSubValidateArgs::Overhead >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | PSV         | 8.4e+04   | 12        | 1          | 1.3e-08 | 20      |
 | manual+dsah | 1.9e+05   | 5.2       | 2.3        | 6.7e-09 | 20      |
 | Type::Tiny  | 2.2e+05   | 4.6       | 2.6        | 5e-09   | 20      |
 | manual      | 4e+05     | 2.5       | 4.8        | 3.3e-09 | 20      |
 | none        | 1.47e+06  | 0.681     | 17.5       | 1.9e-10 | 24      |
 +-------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PerinciSubValidateArgs::Overhead --module-startup >>):

 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                                                          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah | 62        | 57                     | 1          | 0.00017 | 21      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingTypeTiny | 41        | 36                     | 1.5        | 4.5e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV      | 13        | 8                      | 4.9        | 3.6e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually      | 8.3       | 3.3                    | 7.5        | 3.9e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate            | 8.2       | 3.2                    | 7.6        | 3.6e-05 | 20      |
 | perl -e1 (baseline)                                                  | 5         | 0                      | 12         | 2.7e-05 | 24      |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARK NOTES

C<manual> is faster than C<Rinci::Validate>, which is slightly faster than
C<Type::Tiny>, which is faster than C<PSV> and C<manual+dsah>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PerinciSubValidateArgs>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
