package Bencher::Scenario::PerinciSubValidateArgs::Overhead;

our $DATE = '2016-05-23'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

# initialize the validators
use Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV;
Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=>1, a2=>1);

our $scenario = {
    summary => 'Measure validation overhead',
    participants => [
        {
            name => 'none',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'manual+dsah',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)',
        },
        {
            name => 'Rinci::Validate',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingRinciValidate::foo(a1=><a1>, a2=><a2>)',
            include_by_default => 0,
        },
        {
            name => 'PSV',
            fcall_template => 'Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)',
        },
    ],
    datasets => [
        {args => {a1=>1, a2=>1}},
    ],
};

1;
# ABSTRACT: Measure validation overhead

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciSubValidateArgs::Overhead - Measure validation overhead

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::PerinciSubValidateArgs::Overhead (from Perl distribution Bencher-Scenarios-PerinciSubValidateArgs), released on 2016-05-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PerinciSubValidateArgs::Overhead

To run module startup overhead benchmark:

 % bencher --module-startup -m PerinciSubValidateArgs::Overhead

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah>

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV>

=head1 BENCHMARK PARTICIPANTS

=over

=item * none (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate::foo(a1=><a1>, a2=><a2>)



=item * manual (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually::foo(a1=><a1>, a2=><a2>)



=item * manual+dsah (perl_code)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah::foo(a1=><a1>, a2=><a2>)



=item * Rinci::Validate (perl_code) (not included by default)

Function call template:

 Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV::foo(a1=><a1>, a2=><a2>)



=item * PSV (perl_code)

L<Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV>::foo



=back

=head1 BENCHMARK DATASETS

=over

=item * {a1=>1,a2=>1}

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m PerinciSubValidateArgs::Overhead >>):

 +-------------+-----------+-----------+------------+---------+---------+
 | participant | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-------------+-----------+-----------+------------+---------+---------+
 | PSV         | 1.2e+05   | 8.5       | 1          | 1.2e-08 | 23      |
 | manual+dsah | 3.9e+05   | 2.6       | 3.3        | 3.3e-09 | 20      |
 | manual      | 6.11e+05  | 1.64      | 5.17       | 8e-10   | 22      |
 | none        | 1.89e+06  | 0.53      | 16         | 2.5e-10 | 20      |
 +-------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PerinciSubValidateArgs::Overhead --module-startup >>):

 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                                                          | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManualDataSah | 60        | 55.5                   | 1          | 0.00017 | 23      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateUsingPSV      | 12        | 7.5                    | 5.1        | 3.3e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::ValidateManually      | 7.7       | 3.2                    | 7.8        | 2.8e-05 | 20      |
 | Bencher::ScenarioUtil::PerinciSubValidateArgs::NoValidate            | 7.5       | 3                      | 7.9        | 4e-05   | 20      |
 | perl -e1 (baseline)                                                  | 4.5       | 0                      | 13         | 1.1e-05 | 20      |
 +----------------------------------------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PerinciSubValidateArgs>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PerinciSubValidateArgs>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
