package Bencher::Scenario::PerinciCmdLine::ResultStream;

our $DATE = '2016-01-22'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use File::Slurper qw(write_text);
use File::Temp qw(tempdir);
use Perinci::CmdLine::Gen qw(gen_pericmd_script);

my $tempdir;

our $scenario = {
    summary => 'Benchmark result stream vs raw Perl I/O',
    description => <<'_',

Conclusion: about 2.5 times slower on my PC (1.2mil lines/sec vs 3mil).

_
    modules => {
    },
    precision => 2,
    participants => [
    ],
    before_list_participants => sub {
        my %args = @_;

        return if $tempdir;
        my $keep = $ENV{DEBUG_KEEP_TEMPDIR} ? 1:0;
        $tempdir = tempdir(CLEANUP => !$keep);

        my $sc = $args{scenario};
        my $pp = $sc->{participants};

        splice @$pp, 0;

        for my $cmdline (qw/rawperl Inline Lite Classic/) {
            my $progname = "produce-ints-$cmdline";
            my $progpath = "$tempdir/$progname";
            if ($cmdline eq 'rawperl') {
                write_text($progpath, "#!$^X\n" . <<'_');
for (1..$ARGV[1]) { print ++$i, "\n" }
_
                chmod 0755, $progpath;
            } else {
                my $res = gen_pericmd_script(
                    url => "/Perinci/Examples/Stream/produce_ints",
                    cmdline => "Perinci::CmdLine::Lite",
                    output_file => $progpath,
                );
                die "Can't create $progpath: $res->[0] - $res->[1]"
                    unless $res->[0] == 200;
            }

            push @$pp, {
                type => 'command',
                name => $progname,
                cmdline => "$progpath --num 1000000 > /dev/null",
            };
        }

        my $i = 0; for (@$pp) { $_->{seq} = $i++ }
    },
};

1;
# ABSTRACT: Benchmark result stream vs raw Perl I/O

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciCmdLine::ResultStream - Benchmark result stream vs raw Perl I/O

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::PerinciCmdLine::ResultStream (from Perl distribution Bencher-Scenarios-PerinciCmdLine), released on 2016-01-22.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PerinciCmdLine::ResultStream

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PerinciCmdLine::ResultStream >>):

 +----------------------+-----------+-----------+---------+---------+
 | participant          | rate (/s) | time (ms) | errors  | samples |
 +----------------------+-----------+-----------+---------+---------+
 | produce-ints-Lite    | 1         | 8e+02     | 0.013   | 3       |
 | produce-ints-Inline  | 1.2       | 8.2e+02   | 0.0045  | 3       |
 | produce-ints-Classic | 1.26019   | 793.531   | 0       | 2       |
 | produce-ints-rawperl | 3.15      | 317       | 0.00024 | 3       |
 +----------------------+-----------+-----------+---------+---------+

=head1 DESCRIPTION

Conclusion: about 2.5 times slower on my PC (1.2mil lines/sec vs 3mil).


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PerinciCmdLine>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PerinciCmdLine>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PerinciCmdLine>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
