package Bencher::Scenario::PerinciExamples::Startup;

our $DATE = '2016-06-26'; # DATE
our $VERSION = '0.04'; # VERSION

our $scenario = {
    summary => 'Benchmark startup overhead of Perinci::Examples modules',
    module_startup => 1,
    participants => [
        {module=>'Perinci::Examples'},
        {module=>'Perinci::Examples::Tiny'},
        {module=>'Perinci::Examples::CLI'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of Perinci::Examples modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PerinciExamples::Startup - Benchmark startup overhead of Perinci::Examples modules

=head1 VERSION

This document describes version 0.04 of Bencher::Scenario::PerinciExamples::Startup (from Perl distribution Bencher-Scenarios-Perinci), released on 2016-06-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PerinciExamples::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perinci::Examples> 0.73

L<Perinci::Examples::Tiny> 0.73

L<Perinci::Examples::CLI> 0.73

=head1 BENCHMARK PARTICIPANTS

=over

=item * Perinci::Examples (perl_code)

L<Perinci::Examples>



=item * Perinci::Examples::Tiny (perl_code)

L<Perinci::Examples::Tiny>



=item * Perinci::Examples::CLI (perl_code)

L<Perinci::Examples::CLI>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PerinciExamples::Startup >>):

 +-------------------------+-----------+------------------------+------------+---------+---------+
 | participant             | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +-------------------------+-----------+------------------------+------------+---------+---------+
 | Perinci::Examples       |      10   |                    7.5 |        1   | 1.8e-05 |      20 |
 | Perinci::Examples::CLI  |       4.4 |                    1.9 |        2.4 | 1.7e-05 |      21 |
 | Perinci::Examples::Tiny |       2.7 |                    0.2 |        3.8 | 1.5e-05 |      20 |
 | perl -e1 (baseline)     |       2.5 |                    0   |        4.2 | 7.4e-06 |      21 |
 +-------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Perinci>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Perinci>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Perinci>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
