package Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic;

our $DATE = '2016-06-18'; # DATE
our $VERSION = '0.004'; # VERSION

our $scenario = {
    summary => 'Benchmark parse_arithmetic()',
    modules => {
    },
    participants => [
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)',
        },
        {
            fcall_template => 'PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)',
        },
    ],
    datasets => [
        {
            args => {expr => '1'},
        },
        {
            args => {expr => '1' . ('+1' x (  2-1)) },
        },
        {
            args => {expr => '1' . ('+1' x (  5-1)) },
        },
        {
            name => '1+1+..+1 (10x)',
            args => {expr => '1' . ('+1' x ( 10-1)) } },
        {
            name => '1+1+..+1 (20x)',
            args => {expr => '1' . ('+1' x ( 20-1)) },
        },
        {
            name => '1+1+..+1 (100x)',
            args => {expr => '1' . ('+1' x (100-1)) },
        },
        {
            name => '1+1+..+1 (200x)',
            args => {expr => '1' . ('+1' x (200-1)) },
        },
        {
            name => '1+1+..+1 (500x)',
            args => {expr => '1' . ('+1' x (500-1)) },
        },
        {
            name => '1+1+..+1 (1000x)',
            args => {expr => '1' . ('+1' x (1000-1)) },
        },
    ],
};

1;
# ABSTRACT: Benchmark parse_arithmetic()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic - Benchmark parse_arithmetic()

=head1 VERSION

This document describes version 0.004 of Bencher::Scenario::PERLANCARParseArithmetic::parse_arithmetic (from Perl distribution Bencher-Scenarios-PERLANCARParseArithmetic), released on 2016-06-18.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m PERLANCARParseArithmetic::parse_arithmetic

To run module startup overhead benchmark:

 % bencher --module-startup -m PERLANCARParseArithmetic::parse_arithmetic

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<PERLANCAR::Parse::Arithmetic>

L<PERLANCAR::Parse::Arithmetic::Marpa>

L<PERLANCAR::Parse::Arithmetic::NoHash>

=head1 BENCHMARK PARTICIPANTS

=over

=item * PERLANCAR::Parse::Arithmetic::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic(<expr>)



=item * PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic (perl_code)

Function call template:

 PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 1+1

=item * 1+1+1+1+1

=item * 1+1+..+1 (10x)

=item * 1+1+..+1 (20x)

=item * 1+1+..+1 (100x)

=item * 1+1+..+1 (200x)

=item * 1+1+..+1 (500x)

=item * 1+1+..+1 (1000x)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic >>):

 +--------------------------------------------------------+------------------+-----------+-----------+------------+---------+---------+
 | participant                                            | dataset          | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +--------------------------------------------------------+------------------+-----------+-----------+------------+---------+---------+
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (1000x) |       116 |   8.65    |       1    |   5e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (500x)  |       224 |   4.46    |       1.94 | 2.3e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (1000x) |       361 |   2.77    |       3.12 | 4.3e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (1000x) |       384 |   2.61    |       3.32 | 4.8e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (200x)  |       501 |   1.99    |       4.34 | 1.1e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (500x)  |       723 |   1.38    |       6.25 | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (500x)  |       760 |   1.32    |       6.57 | 4.3e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (100x)  |       854 |   1.17    |       7.39 | 1.1e-06 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (200x)  |      1780 |   0.561   |      15.4  | 3.9e-07 |      31 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (200x)  |      1880 |   0.532   |      16.2  | 1.9e-07 |      24 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (20x)   |      2010 |   0.498   |      17.4  | 1.6e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+..+1 (10x)   |      2440 |   0.41    |      21.1  | 2.1e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1+1+1+1        |      2740 |   0.365   |      23.7  | 2.1e-07 |      21 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1+1              |      3020 |   0.332   |      26.1  | 1.6e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::Marpa::parse_arithmetic  | 1                |      3230 |   0.31    |      27.9  | 2.5e-07 |      23 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (100x)  |      3520 |   0.284   |      30.4  |   2e-07 |      23 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (100x)  |      3720 |   0.269   |      32.2  | 2.1e-07 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (20x)   |     17100 |   0.0586  |     148    | 2.2e-08 |      30 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (20x)   |     18300 |   0.0547  |     158    | 2.7e-08 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+..+1 (10x)   |     34000 |   0.029   |     300    | 4.3e-08 |      31 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+..+1 (10x)   |     37000 |   0.027   |     320    | 5.2e-08 |      21 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1+1+1+1        |     67700 |   0.0148  |     586    | 6.7e-09 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1+1+1+1        |     72100 |   0.0139  |     623    |   6e-09 |      25 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1+1              |    158000 |   0.00634 |    1360    | 2.9e-09 |      26 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1+1              |    170000 |   0.006   |    1400    | 6.7e-09 |      20 |
 | PERLANCAR::Parse::Arithmetic::parse_arithmetic         | 1                |    296000 |   0.00338 |    2560    | 1.4e-09 |      28 |
 | PERLANCAR::Parse::Arithmetic::NoHash::parse_arithmetic | 1                |    300000 |   0.00333 |    2600    | 1.4e-09 |      30 |
 +--------------------------------------------------------+------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m PERLANCARParseArithmetic::parse_arithmetic --module-startup >>):

 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                          | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+
 | PERLANCAR::Parse::Arithmetic::Marpa  | 55        |                   52.5 | 1          | 6.2e-05 |      20 |
 | PERLANCAR::Parse::Arithmetic         | 4.7       |                    2.2 | 12         | 1.2e-05 |      20 |
 | PERLANCAR::Parse::Arithmetic::NoHash | 4.7       |                    2.2 | 12         | 1.1e-05 |      20 |
 | perl -e1 (baseline)                  | 2.5       |                    0   | 22         | 4.6e-06 |      21 |
 +--------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-PERLANCARParseArithmetic>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-PERLANCARParseArithmetic>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
