package Bencher::Scenario::MathScientificNotationUtil::sci2dec;

our $DATE = '2016-06-17'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark sci2dec()',
    participants => [
        {
            fcall_template => 'Math::ScientificNotation::Util::sci2dec(<num>)',
        },
        {
            name => 'sprintf("%.f")',
            summary => 'As a baseline',
            code_template => 'sprintf("%.f", <num>)',
        },
        {
            name => 'sprintf("%.g")',
            summary => 'As a baseline',
            code_template => 'sprintf("%.g", <num>)',
        },
    ],
    datasets => [
        {
            args => { 'num@' => ["1.23e20", "1.23e3", "1.23e0", "1.23e-20"] },
        },
    ],
};

1;
# ABSTRACT: Benchmark sci2dec()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::MathScientificNotationUtil::sci2dec - Benchmark sci2dec()

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::MathScientificNotationUtil::sci2dec (from Perl distribution Bencher-Scenarios-MathScientificNotationUtil), released on 2016-06-17.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m MathScientificNotationUtil::sci2dec

To run module startup overhead benchmark:

 % bencher --module-startup -m MathScientificNotationUtil::sci2dec

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Math::ScientificNotation::Util> 0.001

=head1 BENCHMARK PARTICIPANTS

=over

=item * Math::ScientificNotation::Util::sci2dec (perl_code)

Function call template:

 Math::ScientificNotation::Util::sci2dec(<num>)



=item * sprintf("%.f") (perl_code)

As a baseline.

Code template:

 sprintf("%.f", <num>)



=item * sprintf("%.g") (perl_code)

As a baseline.

Code template:

 sprintf("%.g", <num>)



=back

=head1 BENCHMARK DATASETS

=over

=item * ["1.23e20","1.23e3","1.23e0",1.23e-20]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m MathScientificNotationUtil::sci2dec >>):

 +-----------------------------------------+----------+-----------+-----------+------------+---------+---------+
 | participant                             | arg_num  | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +-----------------------------------------+----------+-----------+-----------+------------+---------+---------+
 | Math::ScientificNotation::Util::sci2dec | 1.23e20  | 2.5e+05   | 4         | 1          | 6.7e-09 | 20      |
 | Math::ScientificNotation::Util::sci2dec | 1.23e-20 | 2.7e+05   | 3.7       | 1.1        | 6.5e-09 | 21      |
 | Math::ScientificNotation::Util::sci2dec | 1.23e0   | 3.006e+05 | 3.326     | 1.197      | 2e-10   | 20      |
 | Math::ScientificNotation::Util::sci2dec | 1.23e3   | 4.7e+05   | 2.1       | 1.9        | 3.3e-09 | 21      |
 | sprintf("%.f")                          | 1.23e0   | 1.2e+08   | 0.0084    | 4.7e+02    | 7.3e-11 | 21      |
 | sprintf("%.g")                          | 1.23e20  | 1e+08     | 0.008     | 5e+02      | 4.6e-10 | 21      |
 | sprintf("%.f")                          | 1.23e-20 | 2e+08     | 0.007     | 6e+02      | 4.1e-10 | 20      |
 | sprintf("%.f")                          | 1.23e3   | 2e+08     | 0.006     | 7e+02      | 9.7e-11 | 20      |
 | sprintf("%.f")                          | 1.23e20  | 2e+08     | 0.005     | 8e+02      | 1e-10   | 20      |
 | sprintf("%.g")                          | 1.23e3   | 2.9e+08   | 0.0035    | 1.1e+03    | 1.1e-11 | 20      |
 | sprintf("%.g")                          | 1.23e-20 | 1e+10     | 0.0001    | 4e+04      | 2e-10   | 28      |
 | sprintf("%.g")                          | 1.23e0   | -2e+08    | -0.004    | -9e+02     | 1.5e-10 | 20      |
 +-----------------------------------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m MathScientificNotationUtil::sci2dec --module-startup >>):

 +--------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                    | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +--------------------------------+-----------+------------------------+------------+---------+---------+
 | Math::ScientificNotation::Util | 5.2       | 0.8                    | 1          | 2.7e-05 | 20      |
 | perl -e1 (baseline)            | 4.4       | 0                      | 1.2        | 4e-05   | 20      |
 +--------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-MathScientificNotationUtil>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-MathScientificNotationUtil>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-MathScientificNotationUtil>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
