package Bencher::Scenario::LanguageExpr::Evaluate;

our $DATE = '2016-06-16'; # DATE
our $VERSION = '0.001'; # VERSION

# put shared datasets here
#use Bencher::ScenarioUtil::LanguageExpr;

our $scenario = {
    summary => 'Benchmark evaluation',
    modules => {
        'Language::Expr' => 0.24,
    },
    participants => [
        {
            module => 'Language::Expr::Compiler::perl',
            code_template => 'state $plc = Language::Expr::Compiler::perl->new; $plc->eval(<expr>)',
        },
    ],
    datasets => [
        {
            args => {expr => '1'},
        },
        {
            args => {expr => '1' . ('*1' x (  2-1)) },
        },
        {
            args => {expr => '1' . ('*1' x (  5-1)) },
        },
        {
            name => '1*1*...*1 (10x)',
            args => {expr => '1' . ('*1' x ( 10-1)) } },
        {
            name => '1*1*...*1 (20x)',
            args => {expr => '1' . ('*1' x ( 20-1)) },
        },
        {
            name => '1*1*...*1 (100x)',
            args => {expr => '1' . ('*1' x (100-1)) },
        },
    ],
};

1;
# ABSTRACT: Benchmark evaluation

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LanguageExpr::Evaluate - Benchmark evaluation

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::LanguageExpr::Evaluate (from Perl distribution Bencher-Scenarios-LanguageExpr), released on 2016-06-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LanguageExpr::Evaluate

To run module startup overhead benchmark:

 % bencher --module-startup -m LanguageExpr::Evaluate

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Language::Expr> 0.24

L<Language::Expr::Compiler::perl> 0.24

=head1 BENCHMARK PARTICIPANTS

=over

=item * Language::Expr::Compiler::perl (perl_code)

Code template:

 state $plc = Language::Expr::Compiler::perl->new; $plc->eval(<expr>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 1*1

=item * 1*1*1*1*1

=item * 1*1*...*1 (10x)

=item * 1*1*...*1 (20x)

=item * 1*1*...*1 (100x)

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m LanguageExpr::Evaluate >>):

 +------------------+-----------+-----------+------------+---------+---------+
 | dataset          | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +------------------+-----------+-----------+------------+---------+---------+
 | 1*1*...*1 (100x) | 32        | 31        | 1          | 3.2e-05 | 20      |
 | 1*1*...*1 (20x)  | 162       | 6.19      | 5.08       | 6e-06   | 20      |
 | 1*1*...*1 (10x)  | 310       | 3.22      | 9.75       | 9.1e-07 | 20      |
 | 1*1*1*1*1        | 564       | 1.77      | 17.7       | 1.1e-06 | 20      |
 | 1*1              | 1.1e+03   | 0.93      | 34         | 3.1e-06 | 20      |
 | 1                | 1.67e+03  | 0.599     | 52.4       | 4.4e-07 | 24      |
 +------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-LanguageExpr>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-LanguageExpr>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-LanguageExpr>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
