package Bencher::Scenario::JSONDecodeRegexp;

our $DATE = '2016-11-04'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark JSON decoding',
    participants => [
        {
            fcall_template => 'JSON::Decode::Regexp::from_json(<data>)',
        },
        {
            module => 'JSON::PP',
            function => 'decode',
            code_template => 'state $json = JSON::PP->new->allow_nonref; $json->decode(<data>)',
        },
    ],
    datasets => [
        {name => 'str-a'   , args=>{data=>'"12345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345\f\r\b\t\r"'},
         summary => "a 100-character string with some escape sequences"},
        {name => 'array0'  , args=>{data=>'[]'}},
        {name => 'array1'  , args=>{data=>'[1]'}},
        {name => 'array10' , args=>{data=>'[1,2,3,4,5,6,7,8,9,10]'}},
        {name => 'array100', args=>{data=>'[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,66,67,68,69,70,71,72,73,74,75,76,77,78,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100]'}},
        {name => 'hash0'   , args=>{data=>'{}'}},
        {name => 'hash1'   , args=>{data=>'{"1":1}'}},
        {name => 'hash10'  , args=>{data=>'{"01":1,"02":1,"03":1,"04":1,"05":1,"06":1,"07":1,"08":1,"09":1,"10":1}'}},
        {name => 'hash100' , args=>{data=>'{"001":1,"002":1,"003":1,"004":1,"005":1,"006":1,"007":1,"008":1,"009":1,"010":1,"011":1,"012":1,"013":1,"014":1,"015":1,"016":1,"017":1,"018":1,"019":1,"020":1,"021":1,"022":1,"023":1,"024":1,"025":1,"026":1,"027":1,"028":1,"029":1,"030":1,"031":1,"032":1,"033":1,"034":1,"035":1,"036":1,"037":1,"038":1,"039":1,"040":1,"041":1,"042":1,"043":1,"044":1,"045":1,"046":1,"047":1,"048":1,"049":1,"050":1,"051":1,"052":1,"053":1,"054":1,"055":1,"056":1,"057":1,"058":1,"059":1,"060":1,"061":1,"062":1,"063":1,"064":1,"065":1,"066":1,"067":1,"068":1,"069":1,"070":1,"071":1,"072":1,"073":1,"074":1,"075":1,"076":1,"077":1,"078":1,"079":1,"080":1,"081":1,"082":1,"083":1,"084":1,"085":1,"086":1,"087":1,"088":1,"089":1,"090":1,"091":1,"092":1,"093":1,"094":1,"095":1,"096":1,"097":1,"098":1,"099":1,"100":1}'}},
    ],
};

1;
# ABSTRACT: Benchmark JSON decoding

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::JSONDecodeRegexp - Benchmark JSON decoding

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::JSONDecodeRegexp (from Perl distribution Bencher-Scenarios-JSONDecodeRegexp), released on 2016-11-04.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m JSONDecodeRegexp

To run module startup overhead benchmark:

 % bencher --module-startup -m JSONDecodeRegexp

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<JSON::Decode::Regexp> 0.09

L<JSON::PP> 2.27300

=head1 BENCHMARK PARTICIPANTS

=over

=item * JSON::Decode::Regexp::from_json (perl_code)

Function call template:

 JSON::Decode::Regexp::from_json(<data>)



=item * JSON::PP::decode (perl_code)

Code template:

 state $json = JSON::PP->new->allow_nonref; $json->decode(<data>)



=back

=head1 BENCHMARK DATASETS

=over

=item * str-a

a 100-character string with some escape sequences

=item * array0

=item * array1

=item * array10

=item * array100

=item * hash0

=item * hash1

=item * hash10

=item * hash100

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with C<< bencher -m JSONDecodeRegexp --include-path archive/JSON-Decode-Regexp-0.03/lib --include-path archive/JSON-Decode-Regexp-0.04/lib --include-path archive/JSON-Decode-Regexp-0.06/lib --include-path archive/JSON-Decode-Regexp-0.07/lib --include-path archive/JSON-Decode-Regexp-0.09/lib --multimodver JSON::Decode::Regexp >>:

 #table1#
 {dataset=>"array0"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.06   |     11000 |     89    |        1   | 1.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.03   |     17000 |     57    |        1.5 | 2.9e-07 |      29 |
 | JSON::Decode::Regexp::from_json | 0.04   |     18000 |     54    |        1.6 | 1.9e-07 |      31 |
 | JSON::Decode::Regexp::from_json | 0.09   |    200000 |      6    |       20   | 1.1e-07 |      20 |
 | JSON::PP::decode                |        |    240000 |      4.2  |       21   | 6.7e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |    281000 |      3.55 |       25   | 1.6e-09 |      22 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table2#
 {dataset=>"array1"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.06   |      5100 |    200    |        1   | 3.7e-07 |      26 |
 | JSON::Decode::Regexp::from_json | 0.03   |     14000 |     73    |        2.7 | 6.7e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |     16000 |     62    |        3.2 |   5e-07 |      25 |
 | JSON::Decode::Regexp::from_json | 0.09   |    100000 |      8    |       20   | 3.4e-07 |      20 |
 | JSON::PP::decode                |        |    133000 |      7.53 |       26.2 | 3.3e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |    190000 |      5.4  |       37   | 6.7e-09 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table3#
 {dataset=>"array10"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |      7600 |     130   |       1    | 2.4e-07 |      24 |
 | JSON::Decode::Regexp::from_json | 0.06   |      7800 |     130   |       1    | 2.7e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |     13000 |      77.1 |       1.7  | 2.5e-08 |      22 |
 | JSON::Decode::Regexp::from_json | 0.09   |     30000 |      40   |       4    | 1.5e-06 |      20 |
 | JSON::PP::decode                |        |     28000 |      35   |       3.7  | 4.9e-08 |      24 |
 | JSON::Decode::Regexp::from_json | 0.07   |     41000 |      24.4 |       5.38 | 6.7e-09 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table4#
 {dataset=>"array100"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |      1300 |       780 |       1    | 1.1e-06 |      20 |
 | JSON::PP::decode                |        |      2000 |       500 |       2    | 1.9e-05 |      23 |
 | JSON::Decode::Regexp::from_json | 0.06   |      3100 |       330 |       2.4  | 4.7e-07 |      21 |
 | JSON::Decode::Regexp::from_json | 0.09   |      3700 |       270 |       2.8  | 1.1e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |      3820 |       262 |       2.97 | 2.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |      4700 |       210 |       3.6  | 2.7e-07 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table5#
 {dataset=>"hash0"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.06   |     10000 |        99 |        1   | 2.9e-07 |      28 |
 | JSON::Decode::Regexp::from_json | 0.03   |     17000 |        58 |        1.7 | 5.5e-07 |      21 |
 | JSON::Decode::Regexp::from_json | 0.04   |     19000 |        53 |        1.9 | 1.1e-07 |      20 |
 | JSON::PP::decode                |        |    250000 |         4 |       25   | 6.7e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.09   |    330000 |         3 |       33   | 3.3e-09 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |    340000 |         3 |       33   | 1.4e-08 |      31 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table6#
 {dataset=>"hash1"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.04   |      7100 |     140   |        1   | 6.7e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      8000 |     120   |        1.1 |   6e-07 |      27 |
 | JSON::Decode::Regexp::from_json | 0.03   |     10000 |     100   |        1   | 2.3e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |     75000 |      13   |       11   | 5.3e-08 |      23 |
 | JSON::PP::decode                |        |    100000 |       9.7 |       14   | 1.4e-08 |      30 |
 | JSON::Decode::Regexp::from_json | 0.09   |    120000 |       8.4 |       17   |   3e-08 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table7#
 {dataset=>"hash10"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |      4300 |       230 |        1   | 2.2e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      4600 |       220 |        1.1 | 9.3e-07 |      29 |
 | JSON::Decode::Regexp::from_json | 0.04   |      6000 |       170 |        1.4 | 1.3e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |     11000 |        95 |        2.4 | 1.8e-07 |      21 |
 | JSON::PP::decode                |        |     17000 |        60 |        3.8 | 1.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.09   |     19000 |        52 |        4.4 |   1e-07 |      22 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table8#
 {dataset=>"hash100"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (ms) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.03   |       400 |     2     |       1    | 2.6e-05 |      20 |
 | JSON::Decode::Regexp::from_json | 0.06   |      1000 |     1     |       2    | 1.2e-05 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |      1090 |     0.918 |       2.61 | 9.1e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.04   |      1100 |     0.9   |       2.7  | 1.3e-06 |      20 |
 | JSON::PP::decode                |        |      1500 |     0.66  |       3.6  | 1.2e-06 |      20 |
 | JSON::Decode::Regexp::from_json | 0.09   |      2100 |     0.49  |       4.9  | 1.1e-06 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

 #table9#
 {dataset=>"str-a"}
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | participant                     | modver | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+
 | JSON::Decode::Regexp::from_json | 0.06   |      9100 |     110   |        1   |   4e-07 |      23 |
 | JSON::Decode::Regexp::from_json | 0.04   |     13000 |      75   |        1.5 | 3.2e-07 |      20 |
 | JSON::Decode::Regexp::from_json | 0.03   |     14000 |      71   |        1.5 | 2.1e-07 |      20 |
 | JSON::PP::decode                |        |     16300 |      61.2 |        1.8 | 2.7e-08 |      20 |
 | JSON::Decode::Regexp::from_json | 0.07   |     50000 |      20   |        6   | 8.1e-07 |      28 |
 | JSON::Decode::Regexp::from_json | 0.09   |    100000 |       9.8 |       11   | 1.7e-08 |      20 |
 +---------------------------------+--------+-----------+-----------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-JSONDecodeRegexp>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-JSONDecodeRegexp>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-JSONDecodeRegexp>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
