package Bencher::Scenario::DataSahResolve::Overhead;

our $DATE = '2016-07-21'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark the overhead of resolving schemas',
    modules => {
        'Data::Sah' => {},
        'Data::Sah::Normalize' => {},
        'Data::Sah::Resolve' => {},
    },
    participants => [
        {
            name => 'resolve_schema',
            perl_cmdline_template => ["-MData::Sah::Resolve=resolve_schema", "-e", 'for (@{ <schemas> }) { resolve_schema($_) }'],
        },
        {
            name => 'normalize_schema',
            perl_cmdline_template => ["-MData::Sah::Normalize=normalize_schema", "-e", 'for (@{ <schemas> }) { normalize_schema($_) }'],
        },
        {
            name => 'gen_validator',
            perl_cmdline_template => ["-MData::Sah=gen_validator", "-e", 'for (@{ <schemas> }) { gen_validator($_, {return_type=>q(str)}) }'],
        },
    ],

    datasets => [
        {name=>"int"           , args=>{schemas=>'[q(int)]'}},
        {name=>"perl::modname" , args=>{schemas=>'[q(perl::modname)]'}},
        {name=>"5-schemas"     , args=>{schemas=>'[q(int),q(perl::distname),q(perl::modname),q(posint),q(poseven)]'}},
    ],
};

1;
# ABSTRACT: Benchmark the overhead of resolving schemas

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::DataSahResolve::Overhead - Benchmark the overhead of resolving schemas

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::DataSahResolve::Overhead (from Perl distribution Bencher-Scenarios-DataSahResolve), released on 2016-07-21.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m DataSahResolve::Overhead

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Sah> 0.85

L<Data::Sah::Normalize> 0.04

L<Data::Sah::Resolve> 0.003

=head1 BENCHMARK PARTICIPANTS

=over

=item * resolve_schema (command)

Command line:

 #TEMPLATE: #perl -MData::Sah::Resolve=resolve_schema -e for (@{ <schemas> }) { resolve_schema($_) }



=item * normalize_schema (command)

Command line:

 #TEMPLATE: #perl -MData::Sah::Normalize=normalize_schema -e for (@{ <schemas> }) { normalize_schema($_) }



=item * gen_validator (command)

Command line:

 #TEMPLATE: #perl -MData::Sah=gen_validator -e for (@{ <schemas> }) { gen_validator($_, {return_type=>q(str)}) }



=back

=head1 BENCHMARK DATASETS

=over

=item * int

=item * perl::modname

=item * 5-schemas

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m DataSahResolve::Overhead >>):

 #table1#
 +------------------+---------------+-----------+-----------+------------+-----------+---------+
 | participant      | dataset       | rate (/s) | time (ms) | vs_slowest |  errors   | samples |
 +------------------+---------------+-----------+-----------+------------+-----------+---------+
 | gen_validator    | 5-schemas     |        13 |      77   |        1   |   0.00067 |      21 |
 | gen_validator    | int           |        10 |      80   |        1   |   0.0014  |      20 |
 | gen_validator    | perl::modname |        15 |      66   |        1.2 |   0.00048 |      20 |
 | resolve_schema   | 5-schemas     |        42 |      24   |        3.3 |   0.00011 |      20 |
 | resolve_schema   | perl::modname |        40 |      20   |        3   |   0.00024 |      20 |
 | resolve_schema   | int           |        48 |      21   |        3.7 |   0.00012 |      20 |
 | normalize_schema | int           |       100 |       9   |        8   |   0.00011 |      20 |
 | normalize_schema | 5-schemas     |       130 |       7.7 |       10   | 6.5e-05   |      21 |
 | normalize_schema | perl::modname |       130 |       7.6 |       10   | 5.7e-05   |      20 |
 +------------------+---------------+-----------+-----------+------------+-----------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-DataSahResolve>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-DataSahResolve>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-DataSahResolve>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
