package Bencher::Scenario::Accessors::GeneratorStartup;

our $DATE = '2016-11-26'; # DATE
our $VERSION = '0.13'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark startup of various accessor generators',
    module_startup => 1,
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{ (module=>$spec->{generator}) x !!$spec->{generator} };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark startup of various accessor generators

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::GeneratorStartup - Benchmark startup of various accessor generators

=head1 VERSION

This document describes version 0.13 of Bencher::Scenario::Accessors::GeneratorStartup (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-11-26.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::GeneratorStartup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Struct> 0.65

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Evo::Class>

L<Mo> 0.40

L<Mojo::Base>

L<Mojo::Base::XS> 0.07

L<Moo> 2.002004

L<Moops> 0.034

L<Moos> 0.30

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.17

L<Object::Tiny> 1.08

L<Object::Tiny::RW> 1.07

L<Object::Tiny::RW::XS> 0.03

L<Object::Tiny::XS> 1.01

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Object::Tiny::XS (perl_code)

L<Object::Tiny::XS>



=item * Object::Tiny::RW::XS (perl_code)

L<Object::Tiny::RW::XS>



=item * Class::Struct (perl_code)

L<Class::Struct>



=item * Class::InsideOut (perl_code)

L<Class::InsideOut>



=item * Evo::Class (perl_code)

L<Evo::Class>



=item *  (perl_code)



=item * Moo (perl_code)

L<Moo>



=item * Class::XSAccessor::Array (perl_code)

L<Class::XSAccessor::Array>



=item * Class::XSAccessor (perl_code)

L<Class::XSAccessor>



=item * Object::Tiny::RW (perl_code)

L<Object::Tiny::RW>



=item * Mojo::Base::XS (perl_code)

L<Mojo::Base::XS>



=item * Moos (perl_code)

L<Moos>



=item * Class::Accessor::Array (perl_code)

L<Class::Accessor::Array>



=item * Class::Accessor (perl_code)

L<Class::Accessor>



=item * Simple::Accessor (perl_code)

L<Simple::Accessor>



=item * Mouse (perl_code)

L<Mouse>



=item * Mo (perl_code)

L<Mo>



=item * Moose (perl_code)

L<Moose>



=item *  (perl_code)



=item * Mojo::Base (perl_code)

L<Mojo::Base>



=item * Object::Tiny (perl_code)

L<Object::Tiny>



=item * Moops (perl_code)

L<Moops>



=item * Object::Simple (perl_code)

L<Object::Simple>



=item *  (perl_code)



=item * Class::Tiny (perl_code)

L<Class::Tiny>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m Accessors::GeneratorStartup >>):

 #table1#
 +--------------------------+-----------+------------------------+------------+-----------+---------+
 | participant              | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +--------------------------+-----------+------------------------+------------+-----------+---------+
 | Moose                    |     200   |    191                 |        1   |   0.0008  |      20 |
 | Moops                    |      85   |     76                 |        2.3 |   0.00019 |      20 |
 | Evo::Class               |      45   |     36                 |        4.3 |   0.00019 |      20 |
 | Mouse                    |      32   |     23                 |        6.1 |   0.00018 |      20 |
 | Moo                      |      30   |     21                 |        7   |   0.00058 |      23 |
 | Moos                     |      27   |     18                 |        7.3 |   0.00023 |      20 |
 | Mojo::Base               |      22   |     13                 |        8.8 |   0.00012 |      20 |
 | Class::XSAccessor        |      20   |     11                 |        9   |   0.00033 |      20 |
 | Object::Tiny::RW::XS     |      20   |     11                 |        9   |   0.00064 |      22 |
 | Object::Tiny::XS         |      20   |     11                 |        9   |   0.00085 |      20 |
 | Class::InsideOut         |      20   |     11                 |        9.8 | 3.7e-05   |      22 |
 | Class::XSAccessor::Array |      20   |     11                 |       10   |   0.00026 |      20 |
 | Class::Tiny              |      17   |      8                 |       11   | 3.3e-05   |      20 |
 | Class::Struct            |      15   |      6                 |       13   |   3e-05   |      20 |
 | Class::Accessor          |      15   |      6                 |       13   | 4.5e-05   |      20 |
 | Object::Simple           |      14.9 |      5.9               |       13.1 | 1.3e-05   |      20 |
 | Mojo::Base::XS           |      12   |      3                 |       16   | 9.9e-05   |      20 |
 | Simple::Accessor         |      10   |      1                 |       19   | 3.1e-05   |      20 |
 | Class::Accessor::Array   |       9.7 |      0.699999999999999 |       20   | 2.1e-05   |      20 |
 | Mo                       |       9.3 |      0.300000000000001 |       21   | 2.1e-05   |      21 |
 | perl -e1 (baseline)      |       9   |      0                 |       20   |   0.00016 |      22 |
 | Object::Tiny::RW         |       8   |     -1                 |       24   | 3.1e-05   |      20 |
 | Object::Tiny             |       7.9 |     -1.1               |       25   | 9.1e-06   |      20 |
 +--------------------------+-----------+------------------------+------------+-----------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
