package Bencher::Scenario::Accessors::Get;

our $DATE = '2016-11-25'; # DATE
our $VERSION = '0.12'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read/get',
    modules => {
        # include the generator modules here so we can show their versions in
        # sample benchmark results produced by PWP:Bencher::Scenario
        (map { $_=>0 } grep {defined} map { $classes->{$_}{generator} }
             keys %$classes),
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            my $supports_setters = $spec->{supports_setters} // 1;
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => $supports_setters ?
                    "state \$o = do { my \$o = ${_}->new; \$o->attr1(42); \$o }; \$o->attr1" :
                    "state \$o = do { my \$o = ${_}->new(attr1 => 42); \$o }; \$o->attr1",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o->attr1(42); \$o }; \$o->{attr1}",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o->attr1(42); \$o }; \$o->[0]",
        },
    ],
    result => 42,
};

1;
# ABSTRACT: Benchmark attribute read/get

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Get - Benchmark attribute read/get

=head1 VERSION

This document describes version 0.12 of Bencher::Scenario::Accessors::Get (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-11-25.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Get

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Get

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Class::Accessor> 0.34

L<Class::Accessor::Array> 0.02

L<Class::InsideOut> 1.13

L<Class::Struct> 0.65

L<Class::Tiny> 1.004

L<Class::XSAccessor> 1.19

L<Class::XSAccessor::Array> 1.19

L<Evo::Class>

L<Mo> 0.40

L<Mojo::Base>

L<Mojo::Base::XS> 0.07

L<Moo> 2.002004

L<Moops> 0.034

L<Moos> 0.30

L<Moose> 2.1805

L<Mouse> v2.4.5

L<Object::Simple> 3.17

L<Object::Tiny> 1.08

L<Object::Tiny::RW> 1.07

L<Object::Tiny::RW::XS> 0.03

L<Object::Tiny::XS> 1.01

L<Perl::Examples::Accessors::Array> 0.09

L<Perl::Examples::Accessors::ClassAccessor> 0.09

L<Perl::Examples::Accessors::ClassAccessorArray> 0.09

L<Perl::Examples::Accessors::ClassInsideOut> 0.09

L<Perl::Examples::Accessors::ClassStruct> 0.09

L<Perl::Examples::Accessors::ClassTiny> 0.09

L<Perl::Examples::Accessors::ClassXSAccessor> 0.09

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.09

L<Perl::Examples::Accessors::EvoClass> 0.09

L<Perl::Examples::Accessors::Hash> 0.09

L<Perl::Examples::Accessors::Mo> 0.09

L<Perl::Examples::Accessors::MojoBase> 0.09

L<Perl::Examples::Accessors::MojoBaseXS> 0.09

L<Perl::Examples::Accessors::Moo> 0.09

L<Perl::Examples::Accessors::Moops> 0.09

L<Perl::Examples::Accessors::Moos> 0.09

L<Perl::Examples::Accessors::Moose> 0.09

L<Perl::Examples::Accessors::Mouse> 0.09

L<Perl::Examples::Accessors::ObjectSimple> 0.09

L<Perl::Examples::Accessors::ObjectTiny> 0.09

L<Perl::Examples::Accessors::ObjectTinyRW> 0.09

L<Perl::Examples::Accessors::ObjectTinyRWXS> 0.09

L<Perl::Examples::Accessors::ObjectTinyXS> 0.09

L<Perl::Examples::Accessors::SimpleAccessor> 0.09

L<Simple::Accessor> 1.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::Struct (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassStruct->new; $o->attr1(42); $o }; $o->attr1



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Tiny::RW::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTinyRWXS->new; $o->attr1(42); $o }; $o->attr1



=item * Class::InsideOut (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassInsideOut->new; $o->attr1(42); $o }; $o->attr1



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o->attr1(42); $o }; $o->attr1



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o->attr1(42); $o }; $o->attr1



=item * Mojo::Base (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBase->new; $o->attr1(42); $o }; $o->attr1



=item * Evo::Class (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::EvoClass->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o->attr1(42); $o }; $o->attr1



=item * Simple::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::SimpleAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Mojo::Base::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::MojoBaseXS->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Tiny::XS (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTinyXS->new(attr1 => 42); $o }; $o->attr1



=item * Object::Simple (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectSimple->new; $o->attr1(42); $o }; $o->attr1



=item * Moos (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moos->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Tiny (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassTiny->new; $o->attr1(42); $o }; $o->attr1



=item * Moops (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moops->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Tiny::RW (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTinyRW->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->attr1



=item * Object::Tiny (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ObjectTiny->new(attr1 => 42); $o }; $o->attr1



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->{attr1}



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->[0]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m Accessors::Get >>):

 #table1#
 +----------------------------+-----------+-----------+------------+---------+---------+
 | participant                | rate (/s) | time (ns) | vs_slowest |  errors | samples |
 +----------------------------+-----------+-----------+------------+---------+---------+
 | Class::Accessor            |   2230000 |  449      |    1       | 2.1e-10 |      20 |
 | Simple::Accessor           |   3225550 |  310.025  |    1.44806 |   0     |      22 |
 | Class::InsideOut           |   3300000 |  310      |    1.5     | 3.1e-10 |      20 |
 | Class::Struct              |   4860000 |  206      |    2.18    |   1e-10 |      20 |
 | Evo::Class                 |   5380000 |  186      |    2.41    |   1e-10 |      20 |
 | Mojo::Base                 |   5500000 |  180      |    2.5     | 3.6e-10 |      27 |
 | Mo                         |   5577880 |  179.28   |    2.50409 |   0     |      20 |
 | no generator (hash-based)  |   5865090 |  170.501  |    2.63303 |   0     |      34 |
 | Class::Tiny                |   6192400 |  161.488  |    2.77997 |   0     |      20 |
 | no generator (array-based) |   6480000 |  154      |    2.91    |   1e-10 |      20 |
 | Object::Simple             |   6505480 |  153.717  |    2.92052 |   0     |      20 |
 | Moose                      |   6548450 |  152.708  |    2.93982 |   0     |      32 |
 | Object::Tiny::RW           |   6585450 |  151.85   |    2.95643 |   0     |      21 |
 | Class::Accessor::Array     |   6849920 |  145.987  |    3.07516 |   0     |      20 |
 | Object::Tiny               |   7750000 |  129      |    3.48    | 5.1e-11 |      21 |
 | Mouse                      |  11000000 |   94      |    4.8     | 2.1e-10 |      20 |
 | Moos                       |  12300000 |   81.2    |    5.53    | 5.1e-11 |      21 |
 | Object::Tiny::XS           |  14000000 |   73      |    6.1     | 2.1e-10 |      20 |
 | Object::Tiny::RW::XS       |  14000000 |   72      |    6.2     | 2.6e-10 |      20 |
 | Class::XSAccessor          |  14000000 |   71      |    6.4     | 1.9e-10 |      23 |
 | Mojo::Base::XS             |  14000000 |   70      |    6.4     |   2e-10 |      22 |
 | Moops                      |  15000000 |   67      |    6.7     | 1.6e-10 |      20 |
 | Moo                        |  15136400 |   66.0657 |    6.79525 |   0     |      20 |
 | Class::XSAccessor::Array   |  16309000 |   61.316  |    7.32164 |   0     |      20 |
 | raw hash access            |  27000000 |   37      |   12       |   1e-10 |      20 |
 | raw array access           |  30900000 |   32.3    |   13.9     | 2.6e-11 |      20 |
 +----------------------------+-----------+-----------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
