package Bencher::Scenario::Accessors::Read;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.03'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read',
    modules => {
    },
    participants => [
        (map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o->attr1(42); \$o }; \$o->attr1",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes),

        # also compare with raw hash & array access
        {
            name => 'raw hash access',
            module => 'Perl::Examples::Accessors::Hash',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Hash->new; \$o->attr1(42); \$o }; \$o->{attr1}",
        },
        {
            name => 'raw array access',
            module => 'Perl::Examples::Accessors::Array',
            code_template => "state \$o = do { my \$o = Perl::Examples::Accessors::Array->new; \$o->attr1(42); \$o }; \$o->[0]",
        },
    ],
};

1;
# ABSTRACT: Benchmark attribute read

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Read - Benchmark attribute read

=head1 VERSION

This document describes version 0.03 of Bencher::Scenario::Accessors::Read (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Read

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Read

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (array-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->attr1



=item * no generator (hash-based) (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->attr1



=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o->attr1(42); $o }; $o->attr1



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o->attr1(42); $o }; $o->attr1



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o->attr1(42); $o }; $o->attr1



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o->attr1(42); $o }; $o->attr1



=item * raw hash access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o->attr1(42); $o }; $o->{attr1}



=item * raw array access (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o->attr1(42); $o }; $o->[0]



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m Accessors::Read >>):

 +----------------------------+-------------+-----------+------------+---------+---------+
 | participant                | rate (/s)   | time (ns) | vs_slowest | errors  | samples |
 +----------------------------+-------------+-----------+------------+---------+---------+
 | Class::Accessor            | 1.22e+06    | 817       | 1          | 4.2e-10 | 20      |
 | no generator (hash-based)  | 3.09e+06    | 323       | 2.53       | 2.1e-10 | 24      |
 | Mo                         | 3.2e+06     | 3.2e+02   | 2.6        | 9.8e-10 | 24      |
 | no generator (array-based) | 3.30369e+06 | 302.692   | 2.70029    | 0       | 20      |
 | Moose                      | 3.6e+06     | 2.8e+02   | 2.9        | 3.1e-10 | 20      |
 | Class::Accessor::Array     | 3.8e+06     | 2.6e+02   | 3.1        | 4.2e-10 | 20      |
 | Mouse                      | 8.57e+06    | 117       | 7.01       | 2.2e-11 | 20      |
 | Class::XSAccessor          | 1.1e+07     | 91        | 9          | 1.3e-10 | 30      |
 | Moo                        | 1.2e+07     | 84        | 9.7        | 4.1e-10 | 21      |
 | Class::XSAccessor::Array   | 1e+07       | 8e+01     | 1e+01      | 2.7e-09 | 27      |
 | raw hash access            | 2e+07       | 49        | 17         | 2.2e-10 | 20      |
 | raw array access           | 2.7e+07     | 37        | 22         | 2.1e-10 | 20      |
 +----------------------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
