package Bencher::Scenario::Accessors::Write;

our $DATE = '2016-03-29'; # DATE
our $VERSION = '0.02'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark attribute read',
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "state \$o = do { my \$o = ${_}->new; \$o }; \$o->attr1(42)",
            };
        } grep { !$classes->{$_}{immutable} } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark attribute read

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Write - Benchmark attribute read

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::Accessors::Write (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Write

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Write

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Moose (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moose->new; $o }; $o->attr1(42)



=item * Class::XSAccessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessor->new; $o }; $o->attr1(42)



=item * raw-hash (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Hash->new; $o }; $o->attr1(42)



=item * Mouse (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mouse->new; $o }; $o->attr1(42)



=item * raw-array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Array->new; $o }; $o->attr1(42)



=item * Class::XSAccessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassXSAccessorArray->new; $o }; $o->attr1(42)



=item * Mo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Mo->new; $o }; $o->attr1(42)



=item * Moo (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::Moo->new; $o }; $o->attr1(42)



=item * Class::Accessor (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessor->new; $o }; $o->attr1(42)



=item * Class::Accessor::Array (perl_code)

Code template:

 state $o = do { my $o = Perl::Examples::Accessors::ClassAccessorArray->new; $o }; $o->attr1(42)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Write >>):

 +--------------------------+-----------+-----------+------------+---------+---------+
 | participant              | rate (/s) | time (ns) | vs_slowest | errors  | samples |
 +--------------------------+-----------+-----------+------------+---------+---------+
 | Class::Accessor          | 1e+06     | 9.7e+02   | 1          | 1.3e-09 | 20      |
 | raw-hash                 | 2.58e+06  | 388       | 2.5        | 2.2e-10 | 22      |
 | raw-array                | 2.7e+06   | 3.7e+02   | 2.6        | 1e-09   | 20      |
 | Moose                    | 2.8e+06   | 3.6e+02   | 2.7        | 1.9e-09 | 20      |
 | Class::Accessor::Array   | 3.13e+06  | 319       | 3.04       | 2.4e-10 | 25      |
 | Mo                       | 3.4e+06   | 2.9e+02   | 3.3        | 4.8e-10 | 20      |
 | Mouse                    | 7.4e+06   | 1.3e+02   | 7.2        | 1.3e-09 | 20      |
 | Class::XSAccessor        | 9.1e+06   | 1.1e+02   | 8.8        | 1.4e-10 | 20      |
 | Class::XSAccessor::Array | 9.07e+06  | 110       | 8.79       | 1.1e-10 | 23      |
 | Moo                      | 9.6e+06   | 1e+02     | 9.3        | 1.6e-10 | 20      |
 +--------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
