package Bencher::Scenario::Accessors::Construction;

our $DATE = '2016-03-29'; # DATE
our $VERSION = '0.01'; # VERSION

use Bencher::ScenarioUtil::Accessors;

my $classes = \%Bencher::ScenarioUtil::Accessors::classes;

our $scenario = {
    summary => 'Benchmark object construction',
    modules => {
    },
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                name => $spec->{generator} || $spec->{name},
                module => $_,
                code_template => "${_}->new",
            };
        } keys %$classes,
    ],
};

1;
# ABSTRACT: Benchmark object construction

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Accessors::Construction - Benchmark object construction

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::Accessors::Construction (from Perl distribution Bencher-Scenarios-Accessors), released on 2016-03-29.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Accessors::Construction

To run module startup overhead benchmark:

 % bencher --module-startup -m Accessors::Construction

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Perl::Examples::Accessors::Array> 0.03

L<Perl::Examples::Accessors::ClassAccessor> 0.03

L<Perl::Examples::Accessors::ClassAccessorArray> 0.03

L<Perl::Examples::Accessors::ClassXSAccessor> 0.03

L<Perl::Examples::Accessors::ClassXSAccessorArray> 0.03

L<Perl::Examples::Accessors::Hash> 0.03

L<Perl::Examples::Accessors::Mo> 0.03

L<Perl::Examples::Accessors::Moo> 0.03

L<Perl::Examples::Accessors::Moose> 0.03

L<Perl::Examples::Accessors::Mouse> 0.03

L<Perl::Examples::Accessors::Scalar> 0.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Class::XSAccessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessorArray->new



=item * Class::Accessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessor->new



=item * raw-hash (perl_code)

Code template:

 Perl::Examples::Accessors::Hash->new



=item * raw-scalar (perl_code)

Code template:

 Perl::Examples::Accessors::Scalar->new



=item * Class::Accessor::Array (perl_code)

Code template:

 Perl::Examples::Accessors::ClassAccessorArray->new



=item * Moose (perl_code)

Code template:

 Perl::Examples::Accessors::Moose->new



=item * raw-array (perl_code)

Code template:

 Perl::Examples::Accessors::Array->new



=item * Class::XSAccessor (perl_code)

Code template:

 Perl::Examples::Accessors::ClassXSAccessor->new



=item * Mo (perl_code)

Code template:

 Perl::Examples::Accessors::Mo->new



=item * Mouse (perl_code)

Code template:

 Perl::Examples::Accessors::Mouse->new



=item * Moo (perl_code)

Code template:

 Perl::Examples::Accessors::Moo->new



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Accessors::Construction >>):

 +--------------------------+-------------+-----------+------------+---------+---------+
 | participant              | rate (/s)   | time (μs) | vs_slowest | errors  | samples |
 +--------------------------+-------------+-----------+------------+---------+---------+
 | Moose                    | 4.798e+05   | 2.084     | 1          | 3.5e-11 | 20      |
 | Mo                       | 7.3e+05     | 1.4       | 1.5        | 1.6e-09 | 21      |
 | Moo                      | 9.5e+05     | 1         | 2          | 1.7e-09 | 20      |
 | Class::Accessor          | 1.1e+06     | 0.94      | 2.2        | 1.3e-09 | 20      |
 | Mouse                    | 1.36e+06    | 0.737     | 2.83       | 4.2e-10 | 20      |
 | raw-array                | 1.57e+06    | 0.638     | 3.27       | 1.9e-10 | 23      |
 | raw-hash                 | 2e+06       | 0.51      | 4.1        | 6.5e-10 | 20      |
 | Class::Accessor::Array   | 2.04e+06    | 0.491     | 4.24       | 3.1e-10 | 23      |
 | raw-scalar               | 2.09e+06    | 0.479     | 4.35       | 2.1e-10 | 20      |
 | Class::XSAccessor        | 3.34001e+06 | 0.2994    | 6.96175    | 0       | 20      |
 | Class::XSAccessor::Array | 3.8e+06     | 0.27      | 7.8        | 9.6e-10 | 20      |
 +--------------------------+-------------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-Accessors>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-Accessors>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-Accessors>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
