package Bencher::Scenario::ZodiacModules;

our $DATE = '2015-11-30'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    participants => [
        {
            fcall_template => "Zodiac::Tiny::zodiac_of('2015-11-29')",
        },
        {
            fcall_template => "DateTime::Event::Zodiac::zodiac_date_name(DateTime->new(year=>2015, month=>11, day=>29))",
        },
        {
            fcall_template => "Zodiac::Chinese::Table::chinese_zodiac('2015-11-28')",
        },
        {
            fcall_template => "Zodiac::Chinese::chinese_zodiac(2015,11)",
        },
    ],
};

1;
# ABSTRACT: Benchmark various zodiac modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ZodiacModules - Benchmark various zodiac modules

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::ZodiacModules (from Perl distribution Bencher-Scenario-ZodiacModules), released on 2015-11-30.

=head1 SYNOPSIS

 % bencher -m ZodiacModules [other options]...

=head1 BENCHMARKED MODULES

L<Zodiac::Tiny>

L<DateTime::Event::Zodiac>

L<Zodiac::Chinese::Table>

L<Zodiac::Chinese>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ZodiacModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ZodiacModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ZodiacModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
