package Bencher::Scenario::WordListModules;

our $DATE = '2016-01-07'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark startup overhead of WordList::* modules',
    module_startup => 1,
    default_precision => 0.005,
    participants => [
        {module=>'WordList::ID::KBBI'},
    ],
};

1;
# ABSTRACT: Benchmark startup overhead of WordList::* modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::WordListModules - Benchmark startup overhead of WordList::* modules

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::WordListModules (from Perl distribution Bencher-Scenario-WordListModules), released on 2016-01-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m WordListModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

L<WordList::ID::KBBI> 0.01

=head1 BENCHMARK PARTICIPANTS

=over

=item * WordList::ID::KBBI (perl_code)

L<WordList::ID::KBBI>



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+---------------------+-------+-------------------+---------+---------+
 | seq | name                | time  | mod_overhead_time | errors  | samples |
 +-----+---------------------+-------+-------------------+---------+---------+
 | 1   | WordList::ID::KBBI  | 6.3ms | 1.2ms             | 2.8e-05 | 20      |
 | 0   | perl -e1 (baseline) | 5ms   | 0ms               | 2.3e-05 | 22      |
 +-----+---------------------+-------+-------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-WordListModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-WordListModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-WordListModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
