package Bencher::Scenario::URIEscaping;

our $DATE = '2016-06-16'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use utf8;
use warnings;

# we do this so URI::XSEscaoe does not override URI::Escape's functions, because
# obviously we want to test both
$ENV{PERL_URI_XSESCAPE} = 0;

our $scenario = {
    summary => 'Benchmark URI escaping using various modules',

    precision => 0.001,

    participants => [
        {fcall_template => 'URI::Escape::uri_escape(<str>)', tags=>['escape']},
        {fcall_template => 'URI::Escape::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::Escape::uri_unescape(<str>)', tags=>['unescape']},
        {fcall_template => 'URI::XSEscape::uri_escape(<str>)', tags=>['escape']},
        {fcall_template => 'URI::XSEscape::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::XSEscape::uri_unescape(<str>)', tags=>['unescape']},
        {fcall_template => 'URI::Escape::XS::uri_escape(<str>)', tags=>['escape']},
        #{fcall_template => 'URI::Escape::XS::uri_escape_utf8(<str>)', tags=>['escape', 'utf8']},
        {fcall_template => 'URI::Escape::XS::uri_unescape(<str>)', tags=>['unescape']},
    ],

    datasets => [
        {
            name => 'empty',
            tags => ['escape'],
            include_participant_tags => ['escape'],
            args => {str=>''},
        },
        {
            name => 'ascii53',
            tags => ['escape'],
            include_participant_tags => ['escape'],
            args => {str=>'I said this: you / them ~ us & me _will_ "do-it" NOW!'},
        },
        {
            name => 'utf36',
            tags => ['escape', 'utf8'],
            include_participant_tags => ['escape & utf8'],
            args => {str=>'http://www.google.co.jp/search?q=小飼弾'},
        },
        {
            name => 'u_ascii53',
            tags => ['unescape'],
            include_participant_tags => ['unescape'],
            args => {str=>'I%20said%20this%3a%20you%20%2f%20them%20~%20us%20%26%20me%20_will_%20%22do-it%22%20NOW%21'},
        },
    ],
};

1;
# ABSTRACT: Benchmark URI escaping using various modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::URIEscaping - Benchmark URI escaping using various modules

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::URIEscaping (from Perl distribution Bencher-Scenario-URIEscaping), released on 2016-06-16.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m URIEscaping

To run module startup overhead benchmark:

 % bencher --module-startup -m URIEscaping

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<URI::Escape> 3.31

L<URI::XSEscape> 0.000007

L<URI::Escape::XS> 0.14

=head1 BENCHMARK PARTICIPANTS

=over

=item * URI::Escape::uri_escape (perl_code) [escape]

Function call template:

 URI::Escape::uri_escape(<str>)



=item * URI::Escape::uri_escape_utf8 (perl_code) [escape, utf8]

Function call template:

 URI::Escape::uri_escape_utf8(<str>)



=item * URI::Escape::uri_unescape (perl_code) [unescape]

Function call template:

 URI::Escape::uri_unescape(<str>)



=item * URI::XSEscape::uri_escape (perl_code) [escape]

Function call template:

 URI::XSEscape::uri_escape(<str>)



=item * URI::XSEscape::uri_escape_utf8 (perl_code) [escape, utf8]

Function call template:

 URI::XSEscape::uri_escape_utf8(<str>)



=item * URI::XSEscape::uri_unescape (perl_code) [unescape]

Function call template:

 URI::XSEscape::uri_unescape(<str>)



=item * URI::Escape::XS::uri_escape (perl_code) [escape]

Function call template:

 URI::Escape::XS::uri_escape(<str>)



=item * URI::Escape::XS::uri_unescape (perl_code) [unescape]

Function call template:

 URI::Escape::XS::uri_unescape(<str>)



=back

=head1 BENCHMARK DATASETS

=over

=item * empty [escape]

=item * ascii53 [escape]

=item * utf36 [escape, utf8]

=item * u_ascii53 [unescape]

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m URIEscaping >>):

 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | participant                    | dataset   | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | URI::Escape::uri_escape_utf8   | ascii53   | 7.76e+04  | 12.9      | 1          | 1.2e-08 | 100     |
 | URI::Escape::uri_escape        | ascii53   | 8.37e+04  | 12        | 1.08       | 1.1e-08 | 32      |
 | URI::Escape::uri_escape_utf8   | utf36     | 9.33e+04  | 10.7      | 1.2        | 1.1e-08 | 32      |
 | URI::Escape::uri_unescape      | u_ascii53 | 1.1e+05   | 8.7       | 1.5        | 8.8e-09 | 46      |
 | URI::Escape::uri_escape_utf8   | empty     | 9.411e+05 | 1.063     | 12.13      | 4.6e-11 | 22      |
 | URI::Escape::uri_escape        | empty     | 1.3e+06   | 0.8       | 16         | 8.8e-10 | 72      |
 | URI::Escape::XS::uri_escape    | ascii53   | 1.3e+06   | 0.79      | 16         | 8.8e-10 | 72      |
 | URI::XSEscape::uri_escape_utf8 | ascii53   | 1.31e+06  | 0.761     | 16.9       | 7.2e-10 | 108     |
 | URI::XSEscape::uri_escape_utf8 | utf36     | 1.5e+06   | 0.667     | 19.3       | 4.8e-10 | 61      |
 | URI::Escape::XS::uri_escape    | empty     | 1.539e+06 | 0.6497    | 19.84      | 4.7e-11 | 20      |
 | URI::Escape::XS::uri_unescape  | u_ascii53 | 1.65e+06  | 0.608     | 21.2       | 1.9e-10 | 24      |
 | URI::XSEscape::uri_escape_utf8 | empty     | 1.8e+06   | 0.56      | 23         | 6.5e-10 | 33      |
 | URI::XSEscape::uri_unescape    | u_ascii53 | 2.72e+06  | 0.368     | 35         | 2.1e-10 | 20      |
 | URI::XSEscape::uri_escape      | ascii53   | 2.89e+06  | 0.347     | 37.2       | 4.6e-11 | 21      |
 | URI::XSEscape::uri_escape      | empty     | 4.87e+06  | 0.205     | 62.8       | 1.1e-10 | 22      |
 +--------------------------------+-----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m URIEscaping --module-startup >>):

 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | URI::Escape         | 10.6      | 6.24                   | 1          | 1.1e-05 | 551     |
 | URI::Escape::XS     | 10.6      | 6.24                   | 1.01       | 1e-05   | 379     |
 | URI::XSEscape       | 9.05      | 4.69                   | 1.18       | 8.8e-06 | 441     |
 | perl -e1 (baseline) | 4.36      | 0                      | 2.44       | 4.3e-06 | 1853    |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-URIEscaping>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-URIEscaping>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-URIEscaping>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
