package Bencher::Scenario::SortKeyTop;

our $DATE = '2016-11-13'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Sort::Key::Top',
    participants => [
        {
            name => 'sort',
            summary => "Perl's sort() builtin",
            code_template=>'state $elems=<elems>; my @sorted = sort { $a <=> $b } @$elems; splice @sorted, 0, <n>',
            result_is_list => 1,
        },
        {
            name => 'Sort::Key::Top',
            fcall_template => 'Sort::Key::Top::nkeytopsort(sub { $_ }, <n>, @{<elems>})',
            result_is_list => 1,
        },
        {
            name => 'Sort::Key::Top::PP',
            fcall_template => 'Sort::Key::Top::PP::nkeytopsort(sub { $_ }, <n>, @{<elems>})',
            result_is_list => 1,
        },
    ],
    datasets => [
        {name=>'elems=10 , n=5'    , args=>{elems=>[reverse 1..10]  , n=>  5}},
        {name=>'elems=100, n=10'   , args=>{elems=>[reverse 1..100] , n=> 10}},
        {name=>'elems=1000, n=10'  , args=>{elems=>[reverse 1..1000], n=> 10}},
    ],
};

1;
# ABSTRACT: Benchmark Sort::Key::Top

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::SortKeyTop - Benchmark Sort::Key::Top

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::SortKeyTop (from Perl distribution Bencher-Scenario-SortKeyTop), released on 2016-11-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m SortKeyTop

To run module startup overhead benchmark:

 % bencher --module-startup -m SortKeyTop

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Sort::Key::Top> 0.08

L<Sort::Key::Top::PP> 0.003

=head1 BENCHMARK PARTICIPANTS

=over

=item * sort (perl_code)

Perl's sort() builtin.

Code template:

 state $elems=<elems>; my @sorted = sort { $a <=> $b } @$elems; splice @sorted, 0, <n>



=item * Sort::Key::Top (perl_code)

Function call template:

 Sort::Key::Top::nkeytopsort(sub { $_ }, <n>, @{<elems>})



=item * Sort::Key::Top::PP (perl_code)

Function call template:

 Sort::Key::Top::PP::nkeytopsort(sub { $_ }, <n>, @{<elems>})



=back

=head1 BENCHMARK DATASETS

=over

=item * elems=10 , n=5

=item * elems=100, n=10

=item * elems=1000, n=10

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m SortKeyTop >>):

 #table1#
 +--------------------+------------------+------------+-------------+------------+---------+---------+
 | participant        | dataset          | rate (/s)  | time (μs)   | vs_slowest |  errors | samples |
 +--------------------+------------------+------------+-------------+------------+---------+---------+
 | Sort::Key::Top::PP | elems=1000, n=10 |     849    | 1180        |     1      | 2.7e-07 |      20 |
 | Sort::Key::Top     | elems=1000, n=10 |    5960    |  168        |     7.02   | 4.5e-08 |      28 |
 | Sort::Key::Top::PP | elems=100, n=10  |    8558.93 |  116.837    |    10.0763 |   0     |      30 |
 | sort               | elems=1000, n=10 |   31900    |   31.3      |    37.6    | 1.3e-08 |      21 |
 | Sort::Key::Top     | elems=100, n=10  |   58651.7  |   17.0498   |    69.0499 |   0     |      21 |
 | Sort::Key::Top::PP | elems=10 , n=5   |   93600    |   10.7      |   110      |   1e-08 |      20 |
 | sort               | elems=100, n=10  |  289000    |    3.46     |   340      | 1.6e-09 |      21 |
 | Sort::Key::Top     | elems=10 , n=5   |  476956    |    2.09663  |   561.514  |   0     |      21 |
 | sort               | elems=10 , n=5   | 1416550    |    0.705943 |  1667.68   |   0     |      20 |
 +--------------------+------------------+------------+-------------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m SortKeyTop --module-startup >>):

 #table2#
 +---------------------+-----------+------------------------+------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+-----------+------------------------+------------+---------+---------+
 | Sort::Key::Top::PP  |     11    |                   5.7  |       1    | 3.8e-05 |      20 |
 | Sort::Key::Top      |      9.02 |                   3.72 |       1.19 | 6.7e-06 |      20 |
 | perl -e1 (baseline) |      5.3  |                   0    |       2    | 1.3e-05 |      20 |
 +---------------------+-----------+------------------------+------------+---------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-SortKeyTop>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-SortKeyTop>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-SortKeyTop>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
