package Bencher::Scenario::Perl::Startup;

our $DATE = '2021-07-23'; # DATE
our $VERSION = '0.052'; # VERSION

use 5.010001;
use strict;
use warnings;

use App::perlbrew;
use File::Which;

my $participants = [];

my $pb = App::perlbrew->new;
for my $perl ($pb->installed_perls) {
    push @$participants, {
        name => "$perl->{name} -e1",
        cmdline => [$perl->{executable}, "-e1"],
    };
    if (version->parse($perl->{version}) >= version->parse("5.10.0")) {
        push @$participants, {
            name => "$perl->{name} -E1",
            cmdline => [$perl->{executable}, "-E1"],
        };
    }
}

our $scenario = {
    summary => 'Benchmark startup time of perls',
    default_precision => 0.005,
    participants => $participants,
};

1;
# ABSTRACT: Benchmark startup time of perls

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Perl::Startup - Benchmark startup time of perls

=head1 VERSION

This document describes version 0.052 of Bencher::Scenario::Perl::Startup (from Perl distribution Bencher-Scenario-Perl-Startup), released on 2021-07-23.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Perl::Startup

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Conclusion: in general newer versions of perl has larger startup overhead than
previous ones. If startup overhead is important to you, use C<-e> instead of
C<-E> unless necessary.

=head1 BENCHMARK PARTICIPANTS

=over

=item * perl-5.34.0 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.34.0/bin/perl -e1



=item * perl-5.34.0 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.34.0/bin/perl -E1



=item * perl-5.32.1 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.32.1/bin/perl -e1



=item * perl-5.32.1 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.32.1/bin/perl -E1



=item * perl-5.30.3 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.30.3/bin/perl -e1



=item * perl-5.30.3 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.30.3/bin/perl -E1



=item * perl-5.30.0 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.30.0/bin/perl -e1



=item * perl-5.30.0 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.30.0/bin/perl -E1



=item * perl-5.28.3 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.28.3/bin/perl -e1



=item * perl-5.28.3 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.28.3/bin/perl -E1



=item * perl-5.26.3 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.26.3/bin/perl -e1



=item * perl-5.26.3 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.26.3/bin/perl -E1



=item * perl-5.24.4 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.24.4/bin/perl -e1



=item * perl-5.24.4 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.24.4/bin/perl -E1



=item * perl-5.22.4 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.22.4/bin/perl -e1



=item * perl-5.22.4 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.22.4/bin/perl -E1



=item * perl-5.20.3 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.20.3/bin/perl -e1



=item * perl-5.20.3 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.20.3/bin/perl -E1



=item * perl-5.18.4 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.18.4/bin/perl -e1



=item * perl-5.18.4 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.18.4/bin/perl -E1



=item * perl-5.16.3 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.16.3/bin/perl -e1



=item * perl-5.16.3 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.16.3/bin/perl -E1



=item * perl-5.14.4 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.14.4/bin/perl -e1



=item * perl-5.14.4 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.14.4/bin/perl -E1



=item * perl-5.12.5 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.12.5/bin/perl -e1



=item * perl-5.12.5 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.12.5/bin/perl -E1



=item * perl-5.10.1 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.10.1/bin/perl -e1



=item * perl-5.10.1 -E1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.10.1/bin/perl -E1



=item * perl-5.8.9 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.8.9/bin/perl -e1



=item * perl-5.6.2 -e1 (command)

Command line:

 /home/u1/perl5/perlbrew/perls/perl-5.6.2/bin/perl -e1



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.34.0 >>, CPU: I<< Intel(R) Core(TM) i5-7200U CPU @ 2.50GHz (2 cores) >>, OS: I<< GNU/Linux Ubuntu version 20.04 >>, OS kernel: I<< Linux version 5.3.0-64-generic >>.

Benchmark with default options (C<< bencher -m Perl::Startup >>):

 #table1#
 +-----------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | participant     | rate (/s) | time (ms) | pct_faster_vs_slowest | pct_slower_vs_fastest |  errors | samples |
 +-----------------+-----------+-----------+-----------------------+-----------------------+---------+---------+
 | perl-5.32.1 -E1 |       110 |      9.2  |                 0.00% |                74.27% | 1.8e-05 |      20 |
 | perl-5.30.0 -E1 |       140 |      7.2  |                27.53% |                36.65% | 3.4e-05 |      35 |
 | perl-5.6.2 -e1  |       140 |      7.1  |                29.11% |                34.98% | 2.2e-05 |      42 |
 | perl-5.10.1 -E1 |       140 |      7    |                30.64% |                33.39% | 2.9e-05 |      20 |
 | perl-5.28.3 -E1 |       150 |      6.8  |                34.61% |                29.46% | 3.4e-05 |      54 |
 | perl-5.24.4 -E1 |       150 |      6.8  |                35.12% |                28.97% | 1.3e-05 |      20 |
 | perl-5.30.3 -E1 |       150 |      6.7  |                37.56% |                26.69% | 2.8e-05 |      21 |
 | perl-5.10.1 -e1 |       150 |      6.5  |                40.15% |                24.34% | 3.2e-05 |      21 |
 | perl-5.16.3 -E1 |       150 |      6.5  |                41.13% |                23.48% | 6.7e-06 |      20 |
 | perl-5.18.4 -E1 |       150 |      6.5  |                41.43% |                23.22% | 1.5e-05 |      21 |
 | perl-5.14.4 -E1 |       150 |      6.5  |                41.94% |                22.77% | 3.2e-05 |      24 |
 | perl-5.20.3 -E1 |       160 |      6.4  |                42.48% |                22.32% | 3.1e-05 |      21 |
 | perl-5.34.0 -E1 |       159 |      6.28 |                45.80% |                19.52% | 4.2e-06 |      20 |
 | perl-5.30.0 -e1 |       160 |      6.3  |                46.23% |                19.17% | 1.7e-05 |      21 |
 | perl-5.8.9 -e1  |       160 |      6.2  |                47.23% |                18.37% | 2.7e-05 |      26 |
 | perl-5.28.3 -e1 |       160 |      6.2  |                48.81% |                17.11% | 1.6e-05 |      20 |
 | perl-5.30.3 -e1 |       160 |      6.1  |                49.00% |                16.96% | 2.7e-05 |      40 |
 | perl-5.22.4 -e1 |       160 |      6.1  |                49.52% |                16.55% | 1.5e-05 |      20 |
 | perl-5.12.5 -E1 |       160 |      6.1  |                49.99% |                16.19% | 2.6e-05 |      73 |
 | perl-5.26.3 -E1 |       160 |      6.1  |                50.04% |                16.15% | 7.2e-06 |      20 |
 | perl-5.12.5 -e1 |       160 |      6.1  |                50.36% |                15.90% |   1e-05 |      20 |
 | perl-5.24.4 -e1 |       160 |      6.1  |                50.58% |                15.73% | 8.7e-06 |      20 |
 | perl-5.14.4 -e1 |       170 |      6.1  |                51.33% |                15.16% | 1.7e-05 |      20 |
 | perl-5.16.3 -e1 |       170 |      6    |                52.08% |                14.59% | 1.2e-05 |      21 |
 | perl-5.22.4 -E1 |       167 |      5.98 |                53.29% |                13.69% | 4.9e-06 |      20 |
 | perl-5.32.1 -e1 |       170 |      5.8  |                58.58% |                 9.89% | 9.6e-06 |      20 |
 | perl-5.34.0 -e1 |       180 |      5.5  |                65.61% |                 5.23% | 7.8e-06 |      20 |
 | perl-5.26.3 -e1 |       180 |      5.4  |                69.46% |                 2.84% | 9.6e-06 |      20 |
 | perl-5.20.3 -e1 |       188 |      5.33 |                71.99% |                 1.33% | 3.8e-06 |      20 |
 | perl-5.18.4 -e1 |       190 |      5.26 |                74.27% |                 0.00% | 2.9e-06 |      20 |
 +-----------------+-----------+-----------+-----------------------+-----------------------+---------+---------+


Formatted as L<Benchmark.pm|Benchmark> result:

                    Rate  perl-5.32.1 -E1  perl-5.30.0 -E1  perl-5.6.2 -e1  perl-5.10.1 -E1  perl-5.28.3 -E1  perl-5.24.4 -E1  perl-5.30.3 -E1  perl-5.10.1 -e1  perl-5.16.3 -E1  perl-5.18.4 -E1  perl-5.14.4 -E1  perl-5.20.3 -E1  perl-5.30.0 -e1  perl-5.34.0 -E1  perl-5.8.9 -e1  perl-5.28.3 -e1  perl-5.30.3 -e1  perl-5.22.4 -e1  perl-5.12.5 -E1  perl-5.26.3 -E1  perl-5.12.5 -e1  perl-5.24.4 -e1  perl-5.14.4 -e1  perl-5.16.3 -e1  perl-5.22.4 -E1  perl-5.32.1 -e1  perl-5.34.0 -e1  perl-5.26.3 -e1  perl-5.20.3 -e1  perl-5.18.4 -e1 
  perl-5.32.1 -E1  110/s               --             -21%            -22%             -23%             -26%             -26%             -27%             -29%             -29%             -29%             -29%             -30%             -31%             -31%            -32%             -32%             -33%             -33%             -33%             -33%             -33%             -33%             -33%             -34%             -34%             -36%             -40%             -41%             -42%             -42% 
  perl-5.30.0 -E1  140/s              27%               --             -1%              -2%              -5%              -5%              -6%              -9%              -9%              -9%              -9%             -11%             -12%             -12%            -13%             -13%             -15%             -15%             -15%             -15%             -15%             -15%             -15%             -16%             -16%             -19%             -23%             -25%             -25%             -26% 
  perl-5.6.2 -e1   140/s              29%               1%              --              -1%              -4%              -4%              -5%              -8%              -8%              -8%              -8%              -9%             -11%             -11%            -12%             -12%             -14%             -14%             -14%             -14%             -14%             -14%             -14%             -15%             -15%             -18%             -22%             -23%             -24%             -25% 
  perl-5.10.1 -E1  140/s              31%               2%              1%               --              -2%              -2%              -4%              -7%              -7%              -7%              -7%              -8%              -9%             -10%            -11%             -11%             -12%             -12%             -12%             -12%             -12%             -12%             -12%             -14%             -14%             -17%             -21%             -22%             -23%             -24% 
  perl-5.28.3 -E1  150/s              35%               5%              4%               2%               --               0%              -1%              -4%              -4%              -4%              -4%              -5%              -7%              -7%             -8%              -8%             -10%             -10%             -10%             -10%             -10%             -10%             -10%             -11%             -12%             -14%             -19%             -20%             -21%             -22% 
  perl-5.24.4 -E1  150/s              35%               5%              4%               2%               0%               --              -1%              -4%              -4%              -4%              -4%              -5%              -7%              -7%             -8%              -8%             -10%             -10%             -10%             -10%             -10%             -10%             -10%             -11%             -12%             -14%             -19%             -20%             -21%             -22% 
  perl-5.30.3 -E1  150/s              37%               7%              5%               4%               1%               1%               --              -2%              -2%              -2%              -2%              -4%              -5%              -6%             -7%              -7%              -8%              -8%              -8%              -8%              -8%              -8%              -8%             -10%             -10%             -13%             -17%             -19%             -20%             -21% 
  perl-5.10.1 -e1  150/s              41%              10%              9%               7%               4%               4%               3%               --               0%               0%               0%              -1%              -3%              -3%             -4%              -4%              -6%              -6%              -6%              -6%              -6%              -6%              -6%              -7%              -7%             -10%             -15%             -16%             -17%             -19% 
  perl-5.16.3 -E1  150/s              41%              10%              9%               7%               4%               4%               3%               0%               --               0%               0%              -1%              -3%              -3%             -4%              -4%              -6%              -6%              -6%              -6%              -6%              -6%              -6%              -7%              -7%             -10%             -15%             -16%             -17%             -19% 
  perl-5.18.4 -E1  150/s              41%              10%              9%               7%               4%               4%               3%               0%               0%               --               0%              -1%              -3%              -3%             -4%              -4%              -6%              -6%              -6%              -6%              -6%              -6%              -6%              -7%              -7%             -10%             -15%             -16%             -17%             -19% 
  perl-5.14.4 -E1  150/s              41%              10%              9%               7%               4%               4%               3%               0%               0%               0%               --              -1%              -3%              -3%             -4%              -4%              -6%              -6%              -6%              -6%              -6%              -6%              -6%              -7%              -7%             -10%             -15%             -16%             -17%             -19% 
  perl-5.20.3 -E1  160/s              43%              12%             10%               9%               6%               6%               4%               1%               1%               1%               1%               --              -1%              -1%             -3%              -3%              -4%              -4%              -4%              -4%              -4%              -4%              -4%              -6%              -6%              -9%             -14%             -15%             -16%             -17% 
  perl-5.30.0 -e1  160/s              46%              14%             12%              11%               7%               7%               6%               3%               3%               3%               3%               1%               --               0%             -1%              -1%              -3%              -3%              -3%              -3%              -3%              -3%              -3%              -4%              -5%              -7%             -12%             -14%             -15%             -16% 
  perl-5.34.0 -E1  159/s              46%              14%             13%              11%               8%               8%               6%               3%               3%               3%               3%               1%               0%               --             -1%              -1%              -2%              -2%              -2%              -2%              -2%              -2%              -2%              -4%              -4%              -7%             -12%             -14%             -15%             -16% 
  perl-5.8.9 -e1   160/s              48%              16%             14%              12%               9%               9%               8%               4%               4%               4%               4%               3%               1%               1%              --               0%              -1%              -1%              -1%              -1%              -1%              -1%              -1%              -3%              -3%              -6%             -11%             -12%             -14%             -15% 
  perl-5.28.3 -e1  160/s              48%              16%             14%              12%               9%               9%               8%               4%               4%               4%               4%               3%               1%               1%              0%               --              -1%              -1%              -1%              -1%              -1%              -1%              -1%              -3%              -3%              -6%             -11%             -12%             -14%             -15% 
  perl-5.30.3 -e1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               --               0%               0%               0%               0%               0%               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.22.4 -e1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               --               0%               0%               0%               0%               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.12.5 -E1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               0%               --               0%               0%               0%               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.26.3 -E1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               0%               0%               --               0%               0%               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.12.5 -e1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               0%               0%               0%               --               0%               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.24.4 -e1  160/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               0%               0%               0%               0%               --               0%              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.14.4 -e1  170/s              50%              18%             16%              14%              11%              11%               9%               6%               6%               6%               6%               4%               3%               2%              1%               1%               0%               0%               0%               0%               0%               0%               --              -1%              -1%              -4%              -9%             -11%             -12%             -13% 
  perl-5.16.3 -e1  170/s              53%              19%             18%              16%              13%              13%              11%               8%               8%               8%               8%               6%               5%               4%              3%               3%               1%               1%               1%               1%               1%               1%               1%               --               0%              -3%              -8%              -9%             -11%             -12% 
  perl-5.22.4 -E1  167/s              53%              20%             18%              17%              13%              13%              12%               8%               8%               8%               8%               7%               5%               5%              3%               3%               2%               2%               2%               2%               2%               2%               2%               0%               --              -3%              -8%              -9%             -10%             -12% 
  perl-5.32.1 -e1  170/s              58%              24%             22%              20%              17%              17%              15%              12%              12%              12%              12%              10%               8%               8%              6%               6%               5%               5%               5%               5%               5%               5%               5%               3%               3%               --              -5%              -6%              -8%              -9% 
  perl-5.34.0 -e1  180/s              67%              30%             29%              27%              23%              23%              21%              18%              18%              18%              18%              16%              14%              14%             12%              12%              10%              10%              10%              10%              10%              10%              10%               9%               8%               5%               --              -1%              -3%              -4% 
  perl-5.26.3 -e1  180/s              70%              33%             31%              29%              25%              25%              24%              20%              20%              20%              20%              18%              16%              16%             14%              14%              12%              12%              12%              12%              12%              12%              12%              11%              10%               7%               1%               --              -1%              -2% 
  perl-5.20.3 -e1  188/s              72%              35%             33%              31%              27%              27%              25%              21%              21%              21%              21%              20%              18%              17%             16%              16%              14%              14%              14%              14%              14%              14%              14%              12%              12%               8%               3%               1%               --              -1% 
  perl-5.18.4 -e1  190/s              74%              36%             34%              33%              29%              29%              27%              23%              23%              23%              23%              21%              19%              19%             17%              17%              15%              15%              15%              15%              15%              15%              15%              14%              13%              10%               4%               2%               1%               -- 
 
 Legends:
   perl-5.10.1 -E1: participant=perl-5.10.1 -E1
   perl-5.10.1 -e1: participant=perl-5.10.1 -e1
   perl-5.12.5 -E1: participant=perl-5.12.5 -E1
   perl-5.12.5 -e1: participant=perl-5.12.5 -e1
   perl-5.14.4 -E1: participant=perl-5.14.4 -E1
   perl-5.14.4 -e1: participant=perl-5.14.4 -e1
   perl-5.16.3 -E1: participant=perl-5.16.3 -E1
   perl-5.16.3 -e1: participant=perl-5.16.3 -e1
   perl-5.18.4 -E1: participant=perl-5.18.4 -E1
   perl-5.18.4 -e1: participant=perl-5.18.4 -e1
   perl-5.20.3 -E1: participant=perl-5.20.3 -E1
   perl-5.20.3 -e1: participant=perl-5.20.3 -e1
   perl-5.22.4 -E1: participant=perl-5.22.4 -E1
   perl-5.22.4 -e1: participant=perl-5.22.4 -e1
   perl-5.24.4 -E1: participant=perl-5.24.4 -E1
   perl-5.24.4 -e1: participant=perl-5.24.4 -e1
   perl-5.26.3 -E1: participant=perl-5.26.3 -E1
   perl-5.26.3 -e1: participant=perl-5.26.3 -e1
   perl-5.28.3 -E1: participant=perl-5.28.3 -E1
   perl-5.28.3 -e1: participant=perl-5.28.3 -e1
   perl-5.30.0 -E1: participant=perl-5.30.0 -E1
   perl-5.30.0 -e1: participant=perl-5.30.0 -e1
   perl-5.30.3 -E1: participant=perl-5.30.3 -E1
   perl-5.30.3 -e1: participant=perl-5.30.3 -e1
   perl-5.32.1 -E1: participant=perl-5.32.1 -E1
   perl-5.32.1 -e1: participant=perl-5.32.1 -e1
   perl-5.34.0 -E1: participant=perl-5.34.0 -E1
   perl-5.34.0 -e1: participant=perl-5.34.0 -e1
   perl-5.6.2 -e1: participant=perl-5.6.2 -e1
   perl-5.8.9 -e1: participant=perl-5.8.9 -e1

To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Perl-Startup>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Perl-Startup>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Perl-Startup>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Bencher::Scenario::Interpreters>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
