package Bencher::Scenario::Nums2WordsModules;

our $DATE = '2016-07-13'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark various number-to-words modules '.
        'of different languages against one another',
    participants => [
        {
            fcall_template => 'Lingua::ID::Nums2Words::nums2words(<num>)',
        },
        {
            fcall_template => 'Lingua::FR::Numbers::number_to_fr(<num>)',
        },
        {
            fcall_template => 'Lingua::EN::Numbers::num2en(<num>)',
        },
    ],
    datasets => [
        {args=>{num=>1}},
        {args=>{num=>123}},
        {args=>{num=>123_456_789}},
    ],
};

1;
# ABSTRACT: Benchmark various number-to-words modules of different languages against one another

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Nums2WordsModules - Benchmark various number-to-words modules of different languages against one another

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::Nums2WordsModules (from Perl distribution Bencher-Scenario-Nums2WordsModules), released on 2016-07-13.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m Nums2WordsModules

To run module startup overhead benchmark:

 % bencher --module-startup -m Nums2WordsModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Lingua::ID::Nums2Words> 0.04

L<Lingua::FR::Numbers> 0.04

L<Lingua::EN::Numbers> 2.03

=head1 BENCHMARK PARTICIPANTS

=over

=item * Lingua::ID::Nums2Words::nums2words (perl_code)

Function call template:

 Lingua::ID::Nums2Words::nums2words(<num>)



=item * Lingua::FR::Numbers::number_to_fr (perl_code)

Function call template:

 Lingua::FR::Numbers::number_to_fr(<num>)



=item * Lingua::EN::Numbers::num2en (perl_code)

Function call template:

 Lingua::EN::Numbers::num2en(<num>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 1

=item * 123

=item * 123456789

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.1 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m Nums2WordsModules >>):

 #table1#
 +------------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | participant                        | dataset   | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +------------------------------------+-----------+-----------+-----------+------------+---------+---------+
 | Lingua::ID::Nums2Words::nums2words | 123456789 |     27000 |     37    |     1      |   4e-08 |      20 |
 | Lingua::EN::Numbers::num2en        | 123456789 |     29800 |     33.6  |     1.09   | 1.3e-08 |      20 |
 | Lingua::ID::Nums2Words::nums2words | 123       |     66000 |     15    |     2.4    | 2.7e-08 |      20 |
 | Lingua::FR::Numbers::number_to_fr  | 123456789 |     70524 |     14.18 |     2.5823 | 5.8e-11 |      20 |
 | Lingua::ID::Nums2Words::nums2words | 1         |     85000 |     12    |     3.1    | 1.3e-08 |      20 |
 | Lingua::EN::Numbers::num2en        | 123       |    110000 |      8.9  |     4.1    |   4e-08 |      20 |
 | Lingua::FR::Numbers::number_to_fr  | 123       |    160000 |      6.3  |     5.8    | 1.3e-08 |      20 |
 | Lingua::FR::Numbers::number_to_fr  | 1         |    210000 |      4.8  |     7.6    | 1.3e-08 |      20 |
 | Lingua::EN::Numbers::num2en        | 1         |   2000000 |      0.49 |    75      |   1e-09 |      21 |
 +------------------------------------+-----------+-----------+-----------+------------+---------+---------+


=begin html

<img src="https://api.metacpan.org/source/PERLANCAR/Bencher-Scenario-Nums2WordsModules-0.002/share/images/bencher-result-1.png" />

=end html


Benchmark module startup overhead (C<< bencher -m Nums2WordsModules --module-startup >>):

 #table2#
 +------------------------+-----------+------------------------+------------+-----------+---------+
 | participant            | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors   | samples |
 +------------------------+-----------+------------------------+------------+-----------+---------+
 | Lingua::FR::Numbers    |        12 |                      6 |          1 | 6.4e-05   |      20 |
 | Lingua::ID::Nums2Words |         9 |                      3 |          1 |   0.00014 |      20 |
 | Lingua::EN::Numbers    |         9 |                      3 |          1 |   0.00014 |      20 |
 | perl -e1 (baseline)    |         6 |                      0 |          2 |   0.0001  |      21 |
 +------------------------+-----------+------------------------+------------+-----------+---------+


=begin html

<img src="https://api.metacpan.org/source/PERLANCAR/Bencher-Scenario-Nums2WordsModules-0.002/share/images/bencher-result-2.png" />

=end html


=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Nums2WordsModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Nums2WordsModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Nums2WordsModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
