package Bencher::Scenario::LogAny;

our $DATE = '2016-01-05'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Log::Any',

    description => <<'_',

Early release. Todos include: benchmark enabled level, adapters, string
formatting.

_

    participants => [
        {name=>'log_trace', code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; $log->trace("")'},
        {name=>'if_trace' , code_template=>'state $log = do { require Log::Any; Log::Any->get_logger }; if ($log->is_trace) {}'},
    ],
};

1;
# ABSTRACT: Benchmark Log::Any

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::LogAny

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::LogAny (from Perl distribution Bencher-Scenario-LogAny), released on 2016-01-05.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m LogAny

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 SAMPLE BENCHMARK RESULTS

Run on: CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-------------------------------------------+-----------+---------+---------+---------+
 | seq | name                                      | rate      | time    | errors  | samples |
 +-----+-------------------------------------------+-----------+---------+---------+---------+
 | 0   | {dataset=>undef,participant=>"log_trace"} | 1.264e+06 | 791.3ns | 3.4e-11 | 20      |
 | 1   | {dataset=>undef,participant=>"if_trace"}  | 1.84e+06  | 543ns   | 2e-10   | 23      |
 +-----+-------------------------------------------+-----------+---------+---------+---------+

=head1 DESCRIPTION

Early release. Todos include: benchmark enabled level, adapters, string
formatting.


Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-LogAny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-LogAny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-LogAny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
