package Bencher::Scenario::Interpreters;

our $DATE = '2015-10-09'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    participants => [
        {type=>'command', name=>'perl'  , cmdline=>[qw/perl -e1/]},
        {type=>'command', name=>'bash'  , cmdline=>[qw/bash --norc -c true/]},
        {type=>'command', name=>'ruby'  , cmdline=>[qw/ruby -e1/]},
        {type=>'command', name=>'python', cmdline=>[qw/python -c1/]},
        {type=>'command', name=>'nodejs', cmdline=>[qw/nodejs -e 1/]},
    ],
    on_failure => 'skip',
};

# ABSTRACT: Benchmark startup time of various interpreters

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::Interpreters - Benchmark startup time of various interpreters

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::Interpreters (from Perl distribution Bencher-Scenario-Interpreters), released on 2015-10-09.

=head1 SYNOPSIS

 % bencher -m Interpreters [other options]...

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-Interpreters>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-Interpreters>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-Interpreters>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
