package Bencher::Scenario::IPCSystemOptions;

our $DATE = '2016-01-06'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

require IPC::System::Options;

our $scenario = {
    summary => "Measure the overhead of IPC::System::Options's system()".
        "over CORE::system()",
    default_precision => 0.001,
    participants => [
        {
            name => 'core-true',
            code => sub {
                system {"/bin/true"} "/bin/true";
            },
        },
        {
            name => 'iso-true',
            code => sub {
                IPC::System::Options::system({shell=>0}, "/bin/true");
            },
        },
        {
            name => 'core-perl',
            code => sub {
                system {$^X} $^X, "-e1";
            },
        },
        {
            name => 'iso-perl',
            code => sub {
                IPC::System::Options::system({shell=>0}, $^X, "-e1");
            },
        },
    ],
};

1;
# ABSTRACT: Measure the overhead of IPC::System::Options's system()over CORE::system()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::IPCSystemOptions

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::IPCSystemOptions (from Perl distribution Bencher-Scenario-IPCSystemOptions), released on 2016-01-06.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m IPCSystemOptions

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARK PARTICIPANTS

=over

=item * core-true (perl_code)



=item * iso-true (perl_code)



=item * core-perl (perl_code)



=item * iso-perl (perl_code)



=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default option:

 +-----+-----------+------+--------+---------+---------+
 | seq | name      | rate | time   | errors  | samples |
 +-----+-----------+------+--------+---------+---------+
 | 3   | iso-perl  | 223  | 4.48ms | 4.4e-06 | 1018    |
 | 2   | core-perl | 229  | 4.36ms | 4.3e-06 | 973     |
 | 1   | iso-true  | 334  | 3ms    | 2.9e-06 | 1184    |
 | 0   | core-true | 346  | 2.89ms | 2.8e-06 | 1558    |
 +-----+-----------+------+--------+---------+---------+

=head1 DESCRIPTION

Conclusion: Testing on my system (L<IPC::System::Options> 0.24, perl: 5.22.0,
CPU: Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores)) shows the overhead to be
~40μs (0.04ms) so for benchmarking commands that have overhead in the range of
10-100ms we normally don't need to worry about the overhead of
IPC::System::Option (0.04-0.4%) when we are using default precision (~1%).

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-IPCSystemOptions>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-IPCSystemOptions>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-IPCSystemOptions>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
