package Bencher::Scenario::GraphTopologicalSortModules;

our $DATE = '2017-01-25'; # DATE
our $VERSION = '0.002'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark graph topological sort modules',
    modules => {
    },
    participants => [
        {
            module => 'Sort::Topological',
            function => 'toposort',
            code_template  => 'my $graph = <graph>; Sort::Topological::toposort(sub { @{ $graph->{shift} || [] } }, <unsorted>)',
            result_is_list => 1,
        },
        {
            fcall_template => 'Data::Graph::Util::toposort(<graph>, <unsorted>)',
            result_is_list => 1,
        },
    ],

    datasets => [
        {
            name => 'g1',
            args => {
                graph => {
                    'a' => [ 'b', 'c' ],
                    'c' => [ 'x' ],
                    'b' => [ 'x' ],
                    'x' => [ 'y' ],
                    'y' => [ 'z' ],
                    'z' => [ ],
                },
                unsorted => ['z', 'a', 'x', 'c', 'b', 'y'],
            },
        },
    ],
};

1;
# ABSTRACT: Benchmark graph topological sort modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::GraphTopologicalSortModules - Benchmark graph topological sort modules

=head1 VERSION

This document describes version 0.002 of Bencher::Scenario::GraphTopologicalSortModules (from Perl distribution Bencher-Scenario-GraphTopologicalSortModules), released on 2017-01-25.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m GraphTopologicalSortModules

To run module startup overhead benchmark:

 % bencher --module-startup -m GraphTopologicalSortModules

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Data::Graph::Util> 0.002

L<Sort::Topological> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Sort::Topological::toposort (perl_code)

Code template:

 my $graph = <graph>; Sort::Topological::toposort(sub { @{ $graph->{shift} || [] } }, <unsorted>)



=item * Data::Graph::Util::toposort (perl_code)

Function call template:

 Data::Graph::Util::toposort(<graph>, <unsorted>)



=back

=head1 BENCHMARK DATASETS

=over

=item * g1

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.24.0 >>, CPU: I<< Intel(R) Core(TM) M-5Y71 CPU @ 1.20GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17.3 >>, OS kernel: I<< Linux version 3.19.0-32-generic >>.

Benchmark with default options (C<< bencher -m GraphTopologicalSortModules >>):

 #table1#
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | participant                 | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-----------------------------+-----------+-----------+------------+---------+---------+
 | Sort::Topological::toposort |     78300 |      12.8 |          1 | 6.7e-09 |      20 |
 | Data::Graph::Util::toposort |     81000 |      12   |          1 | 1.3e-08 |      21 |
 +-----------------------------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m GraphTopologicalSortModules --module-startup >>):

 #table2#
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | participant         | proc_private_dirty_size (kB) | proc_rss_size (MB) | proc_size (MB) | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+
 | Data::Graph::Util   | 840                          | 4.1                | 16             |       7.7 |                    3.4 |        1   | 4.6e-05 |      20 |
 | Sort::Topological   | 972                          | 4.4                | 16             |       7.6 |                    3.3 |        1   |   3e-05 |      20 |
 | perl -e1 (baseline) | 992                          | 4.3                | 16             |       4.3 |                    0   |        1.8 | 6.9e-06 |      20 |
 +---------------------+------------------------------+--------------------+----------------+-----------+------------------------+------------+---------+---------+


To display as an interactive HTML table on a browser, you can add option C<--format html+datatables>.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-GraphTopologicalSortModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-GraphTopologicalSortModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-GraphTopologicalSortModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
