package Bencher::Scenario::BigFloat;

our $DATE = '2016-01-31'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark arbitrary size floating point arithmetics',
    participants => [
        {
            name => '1k-Math::BigFloat',
            module=>'Math::BigFloat',
            code_template => 'my $val; for (1..1000) { $val = Math::BigFloat->new(q(<num1>))+Math::BigFloat->new(q(<num2>)) + Math::BigFloat->new(q(<num1>)) * Math::BigFloat->new(q(<num2>)) } "$val"'
        },
        {
            name => '1k-native',
            tags => ['no-big'],
            code_template => 'my $val; for (1..1000) { $val = <num1>+<num2> + <num1> * <num2> } $val'
        },
    ],
    datasets => [
        {name=>'0dec_digits', args=>{num1=>"10", num2=>"20"}, result=>"230" },
        {name=>'100dec_digits', args=>{num1=>"1.".("12"x50),num2=>"2"}, result=>"5.".("36"x50), exclude_participant_tags=>['no-big'] },
    ],
};

1;
# ABSTRACT: Benchmark arbitrary size floating point arithmetics

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::BigFloat - Benchmark arbitrary size floating point arithmetics

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::BigFloat (from Perl distribution Bencher-Scenario-BigFloat), released on 2016-01-31.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m BigFloat

To run module startup overhead benchmark:

 % bencher --module-startup -m BigFloat

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Math::BigFloat> 1.9997

=head1 BENCHMARK PARTICIPANTS

=over

=item * 1k-Math::BigFloat (perl_code)

Code template:

 my $val; for (1..1000) { $val = Math::BigFloat->new(q(<num1>))+Math::BigFloat->new(q(<num2>)) + Math::BigFloat->new(q(<num1>)) * Math::BigFloat->new(q(<num2>)) } "$val"



=item * 1k-native (perl_code) [no-big]

Code template:

 my $val; for (1..1000) { $val = <num1>+<num2> + <num1> * <num2> } $val



=back

=head1 BENCHMARK DATASETS

=over

=item * 0dec_digits

=item * 100dec_digits

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m BigFloat >>):

 +-------------------+---------------+-----------+-----------+---------+---------+
 | participant       | dataset       | rate (/s) | time (ms) | errors  | samples |
 +-------------------+---------------+-----------+-----------+---------+---------+
 | 1k-Math::BigFloat | 100dec_digits | 8.1       | 124       | 5.5e-05 | 20      |
 | 1k-Math::BigFloat | 0dec_digits   | 9.52      | 105       | 3.4e-05 | 20      |
 | 1k-native         | 0dec_digits   | 3.18e+04  | 0.0315    | 1.3e-08 | 20      |
 +-------------------+---------------+-----------+-----------+---------+---------+


Benchmark module startup overhead (C<< bencher -m BigFloat --module-startup >>):

 +---------------------+-----------+------------------------+---------+---------+
 | participant         | time (ms) | mod_overhead_time (ms) | errors  | samples |
 +---------------------+-----------+------------------------+---------+---------+
 | Math::BigFloat      | 27        | 24.6                   | 5.1e-05 | 20      |
 | perl -e1 (baseline) | 2.4       | 0                      | 7.1e-06 | 20      |
 +---------------------+-----------+------------------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-BigFloat>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-BigFloat>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-BigFloat>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
