package Bencher::Scenario::AcmePERLANCARTestPerformance;

our $DATE = '2016-03-15'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Acme::PERLANCAR::Test::Performance',
    participants => [
        {
            fcall_template => 'Acme::PERLANCAR::Test::Performance::primes(<num>)', result_is_list=>1,
        },
    ],
    datasets => [
        {name=>'100', args=>{num=>100}},
    ],
};

1;
# ABSTRACT: Benchmark Acme::PERLANCAR::Test::Performance

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::AcmePERLANCARTestPerformance - Benchmark Acme::PERLANCAR::Test::Performance

=head1 VERSION

This document describes version 0.01 of Bencher::Scenario::AcmePERLANCARTestPerformance (from Perl distribution Bencher-Scenario-AcmePERLANCARTestPerformance), released on 2016-03-15.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m AcmePERLANCARTestPerformance

To run module startup overhead benchmark:

 % bencher --module-startup -m AcmePERLANCARTestPerformance

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Acme::PERLANCAR::Test::Performance> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Acme::PERLANCAR::Test::Performance::primes (perl_code)

Function call template:

 Acme::PERLANCAR::Test::Performance::primes(<num>)



=back

=head1 BENCHMARK DATASETS

=over

=item * 100

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2557M CPU @ 1.70GHz (2 cores) >>, OS: I<< GNU/Linux LinuxMint version 17 >>, OS kernel: I<< Linux version 3.13.0-32-generic >>.

Benchmark with default options (C<< bencher -m AcmePERLANCARTestPerformance >>):

 +--------------------------------------------+---------+-----------+-----------+------------+---------+---------+
 | participant                                | dataset | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +--------------------------------------------+---------+-----------+-----------+------------+---------+---------+
 | Acme::PERLANCAR::Test::Performance::primes | 100     | 1.73e+03  | 577       | 1          | 2.1e-07 | 20      |
 +--------------------------------------------+---------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m AcmePERLANCARTestPerformance --module-startup >>):

 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | participant                        | time (ms) | mod_overhead_time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+------------------------+------------+---------+---------+
 | Acme::PERLANCAR::Test::Performance | 22        | 12                     | 1          | 0.00013 | 20      |
 | perl -e1 (baseline)                | 10        | 0                      | 2          | 0.00028 | 20      |
 +------------------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-AcmePERLANCARTestPerformance>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-AcmePERLANCARTestPerformance>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-AcmePERLANCARTestPerformance>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
