package App::lcpan::Cmd::modules;

our $DATE = '2015-04-07'; # DATE
our $VERSION = '0.14'; # VERSION

use 5.010;
use strict;
use warnings;

require App::lcpan;

our %SPEC;

$SPEC{':package'} = {
    v => 1.1,
    summary => "'modules' command",
};

$SPEC{handle_cmd} = $App::lcpan::SPEC{list_local_cpan_modules};
*handle_cmd = \&App::lcpan::list_local_cpan_modules;

1;
# ABSTRACT: 'modules' command

__END__

=pod

=encoding UTF-8

=head1 NAME

App::lcpan::Cmd::modules - 'modules' command

=head1 VERSION

This document describes version 0.14 of App::lcpan::Cmd::modules (from Perl distribution App-lcpan), released on 2015-04-07.

=head1 FUNCTIONS


=head2 handle_cmd(%args) -> any

List packages/modules.

Arguments ('*' denotes required arguments):

=over 4

=item * B<author> => I<str>

Filter by author.

=item * B<cpan> => I<str>

Location of your local CPAN mirror, e.g. /path/to/cpan.

Defaults to C<~/cpan>.

=item * B<detail> => I<bool>

=item * B<dist> => I<str>

Filter by distribution.

=item * B<index_name> => I<str> (default: "index.db")

Filename of index.

=item * B<query> => I<str>

Search query.

=back

Return value:  (any)


By default will return an array of package names. If you set C<detail> to true,
will return array of records.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-lcpan>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-lcpan>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-lcpan>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
