package Acme::CPANAuthors::CPAN::Streaks::WeeklyDistributions::AllTime;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-21'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240221.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'SKIM' => '',
    'KENTNL' => '',
    'SHARYANTO' => '',
    'IVANWILLS' => '',
    'BARBIE' => '',
    'CSSON' => '',
    'TOBYINK' => '',
    'ZOFFIX' => '',
    'FAYLAND' => '',
    'BOBTFISH' => '',
    'RJBS' => '',
    'FLORA' => '',
    'DAGOLDEN' => '',
    'NEILB' => '',
    'ADAMK' => '',
    'SKI' => '',
    'INGY' => '',
    'ELIZABETH' => '',
    'BDFOY' => '',
    'SOFTDIA' => '',
    'MARCEL' => '',
    'MIYAGAWA' => '',
    'SIMON' => '',
    'BINGOS' => '',
    'WOLDRICH' => '',
    'BRADH' => '',
    'TOKUHIROM' => '',
    'ETHER' => '',
    'TULAMILI' => '',
    'PEVANS' => '',
    'GAAS' => '',
    'SCHUBIGER' => '',
    'CWEST' => '',
    'AUTRIJUS' => '',
    'ANDYA' => '',
    'DMAKI' => '',
    'MALUKU' => '',
    'RKRIMEN' => '',
    'NKH' => '',
    'ROKR' => '',
    'GRAY' => '',
    'ALEXMV' => '',
    'BINARY' => '',
    'JJNAPIORK' => '',
    'PLICEASE' => '',
    'LNATION' => '',
    'KIMOTO' => '',
);


1;
# ABSTRACT: Authors with all-time weekly distributions streak (release a new [for them] distribution every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyDistributions::AllTime - Authors with all-time weekly distributions streak (release a new [for them] distribution every week)

=head1 VERSION

This document describes version 20240221.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyDistributions::AllTime (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-21.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-21, produced by L<cpan-streaks>, only streaks with length of at least 6 are included):

  +-----------+-----+------------+------------+---------+
  | author    | len | start_date | end_date   | status  |
  +-----------+-----+------------+------------+---------+
  | PERLANCAR | 496 | 2014-08-24 |            | ongoing |
  | SKIM      |  29 | 2014-09-14 | 2015-03-29 | broken  |
  | KENTNL    |  26 | 2014-05-18 | 2014-11-09 | broken  |
  | SHARYANTO |  25 | 2014-03-02 | 2014-08-17 | broken  |
  | IVANWILLS |  19 | 2015-03-15 | 2015-07-19 | broken  |
  | BARBIE    |  17 | 2014-03-30 | 2014-07-20 | broken  |
  | CSSON     |  16 | 2014-12-07 | 2015-03-22 | broken  |
  | TOBYINK   |  13 | 2012-06-24 | 2012-09-16 | broken  |
  | ZOFFIX    |  12 | 2008-01-27 | 2008-04-13 | broken  |
  | FAYLAND   |  12 | 2008-09-28 | 2008-12-14 | broken  |
  | BOBTFISH  |  12 | 2009-10-04 | 2009-12-20 | broken  |
  | TOBYINK   |  12 | 2013-02-03 | 2013-04-21 | broken  |
  | SHARYANTO |  11 | 2011-07-24 | 2011-10-02 | broken  |
  | RJBS      |  10 | 2004-08-22 | 2004-10-24 | broken  |
  | FLORA     |  10 | 2009-03-22 | 2009-05-24 | broken  |
  | TOBYINK   |  10 | 2012-10-14 | 2012-12-16 | broken  |
  | DAGOLDEN  |  10 | 2013-01-06 | 2013-03-10 | broken  |
  | NEILB     |  10 | 2014-02-16 | 2014-04-20 | broken  |
  | TOBYINK   |  10 | 2014-03-30 | 2014-06-01 | broken  |
  | ADAMK     |   9 | 2006-08-27 | 2006-10-22 | broken  |
  | SKI       |   9 | 2007-05-27 | 2007-07-22 | broken  |
  | INGY      |   9 | 2011-08-14 | 2011-10-09 | broken  |
  | TOBYINK   |   9 | 2012-04-15 | 2012-06-10 | broken  |
  | ELIZABETH |   8 | 2002-06-23 | 2002-08-11 | broken  |
  | BDFOY     |   8 | 2002-08-11 | 2002-09-29 | broken  |
  | SOFTDIA   |   8 | 2003-06-01 | 2003-07-20 | broken  |
  | MARCEL    |   8 | 2007-10-14 | 2007-12-02 | broken  |
  | SHARYANTO |   8 | 2011-02-06 | 2011-03-27 | broken  |
  | MIYAGAWA  |   7 | 2001-09-16 | 2001-10-28 | broken  |
  | SIMON     |   7 | 2004-06-06 | 2004-07-18 | broken  |
  | ZOFFIX    |   7 | 2008-10-05 | 2008-11-16 | broken  |
  | BINGOS    |   7 | 2009-04-12 | 2009-05-24 | broken  |
  | WOLDRICH  |   7 | 2010-12-26 | 2011-02-06 | broken  |
  | BRADH     |   7 | 2011-09-25 | 2011-11-06 | broken  |
  | SHARYANTO |   7 | 2012-01-15 | 2012-02-26 | broken  |
  | SHARYANTO |   7 | 2012-06-24 | 2012-08-05 | broken  |
  | TOKUHIROM |   7 | 2013-03-10 | 2013-04-21 | broken  |
  | ETHER     |   7 | 2013-04-14 | 2013-05-26 | broken  |
  | TOBYINK   |   7 | 2013-06-30 | 2013-08-11 | broken  |
  | TOKUHIROM |   7 | 2013-09-01 | 2013-10-13 | broken  |
  | KENTNL    |   7 | 2013-11-03 | 2013-12-15 | broken  |
  | ZOFFIX    |   7 | 2013-12-22 | 2014-02-02 | broken  |
  | ETHER     |   7 | 2014-04-06 | 2014-05-18 | broken  |
  | INGY      |   7 | 2014-07-20 | 2014-08-31 | broken  |
  | SKIM      |   7 | 2014-07-20 | 2014-08-31 | broken  |
  | ETHER     |   7 | 2015-04-26 | 2015-06-07 | broken  |
  | TULAMILI  |   7 | 2018-06-10 | 2018-07-22 | broken  |
  | PEVANS    |   7 | 2021-07-25 | 2021-09-05 | broken  |
  | GAAS      |   6 | 1997-12-28 | 1998-02-01 | broken  |
  | SIMON     |   6 | 2003-10-05 | 2003-11-09 | broken  |
  | SCHUBIGER |   6 | 2003-12-21 | 2004-01-25 | broken  |
  | CWEST     |   6 | 2004-06-27 | 2004-08-01 | broken  |
  | AUTRIJUS  |   6 | 2004-09-12 | 2004-10-17 | broken  |
  | ADAMK     |   6 | 2004-10-31 | 2004-12-05 | broken  |
  | ADAMK     |   6 | 2005-04-03 | 2005-05-08 | broken  |
  | RJBS      |   6 | 2006-07-02 | 2006-08-06 | broken  |
  | ANDYA     |   6 | 2006-11-19 | 2006-12-24 | broken  |
  | DMAKI     |   6 | 2008-07-06 | 2008-08-10 | broken  |
  | MALUKU    |   6 | 2009-01-11 | 2009-02-15 | broken  |
  | RKRIMEN   |   6 | 2009-05-03 | 2009-06-07 | broken  |
  | NKH       |   6 | 2010-03-28 | 2010-05-02 | broken  |
  | FLORA     |   6 | 2010-05-02 | 2010-06-06 | broken  |
  | ROKR      |   6 | 2010-05-09 | 2010-06-13 | broken  |
  | TOKUHIROM |   6 | 2010-07-04 | 2010-08-08 | broken  |
  | FLORA     |   6 | 2010-08-08 | 2010-09-12 | broken  |
  | TOBYINK   |   6 | 2010-08-15 | 2010-09-19 | broken  |
  | GRAY      |   6 | 2010-11-07 | 2010-12-12 | broken  |
  | INGY      |   6 | 2011-05-08 | 2011-06-12 | broken  |
  | ETHER     |   6 | 2012-06-03 | 2012-07-08 | broken  |
  | ETHER     |   6 | 2014-01-05 | 2014-02-09 | broken  |
  | NEILB     |   6 | 2014-06-01 | 2014-07-06 | broken  |
  | ALEXMV    |   6 | 2014-06-08 | 2014-07-13 | broken  |
  | ETHER     |   6 | 2014-06-29 | 2014-08-03 | broken  |
  | BINARY    |   6 | 2014-08-31 | 2014-10-05 | broken  |
  | JJNAPIORK |   6 | 2015-04-19 | 2015-05-24 | broken  |
  | PLICEASE  |   6 | 2017-07-09 | 2017-08-13 | broken  |
  | LNATION   |   6 | 2020-03-29 | 2020-05-03 | broken  |
  | SKIM      |   6 | 2022-08-14 | 2022-09-18 | broken  |
  | KIMOTO    |   6 | 2023-01-22 | 2023-02-26 | broken  |
  +-----------+-----+------------+------------+---------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
