package Acme::CPANAuthors::CPAN::Streaks::DailyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-02-21'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240221.0'; # VERSION

use Acme::CPANAuthors::Register (
    'KIMOTO' => '',
    'PMQS' => '',
    'JV' => '',
    'LITCHIE' => '',
    'PERLANCAR' => '',
    'NHORNE' => '',
    'OETIKER' => '',
    'TYRRMINAL' => '',
    'ABALAMA' => '',
    'FASTLY' => '',
    'JIMAVERA' => '',
    'KJETILK' => '',
    'OALDERS' => '',
    'OODLER' => '',
    'RAWLEYFOW' => '',
    'SANKO' => '',
    'VOLKENING' => '',
    'CRORAA' => '',
    'DWHEELER' => '',
    'ETJ' => '',
    'GBROWN' => '',
    'JDDPAUSE' => '',
    'KRYDE' => '',
    'MLEHMANN' => '',
    'VVELOX' => '',
);


1;
# ABSTRACT: Authors with ongoing daily releases streak (do a release everyday)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::DailyReleases::Current - Authors with ongoing daily releases streak (do a release everyday)

=head1 VERSION

This document describes version 20240221.0 of Acme::CPANAuthors::CPAN::Streaks::DailyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-02-21.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-02-21, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | KIMOTO    |   3 | 2024-02-18 | ongoing     |
  | PMQS      |   3 | 2024-02-18 | ongoing     |
  | JV        |   2 | 2024-02-18 | might-break |
  | LITCHIE   |   2 | 2024-02-18 | might-break |
  | PERLANCAR |   2 | 2024-02-18 | might-break |
  | NHORNE    |   2 | 2024-02-19 | ongoing     |
  | OETIKER   |   2 | 2024-02-19 | ongoing     |
  | TYRRMINAL |   2 | 2024-02-19 | ongoing     |
  | ABALAMA   |   1 | 2024-02-19 | might-break |
  | FASTLY    |   1 | 2024-02-19 | might-break |
  | JIMAVERA  |   1 | 2024-02-19 | might-break |
  | KJETILK   |   1 | 2024-02-19 | might-break |
  | OALDERS   |   1 | 2024-02-19 | might-break |
  | OODLER    |   1 | 2024-02-19 | might-break |
  | RAWLEYFOW |   1 | 2024-02-19 | might-break |
  | SANKO     |   1 | 2024-02-19 | might-break |
  | VOLKENING |   1 | 2024-02-19 | might-break |
  | CRORAA    |   1 | 2024-02-20 | ongoing     |
  | DWHEELER  |   1 | 2024-02-20 | ongoing     |
  | ETJ       |   1 | 2024-02-20 | ongoing     |
  | GBROWN    |   1 | 2024-02-20 | ongoing     |
  | JDDPAUSE  |   1 | 2024-02-20 | ongoing     |
  | KRYDE     |   1 | 2024-02-20 | ongoing     |
  | MLEHMANN  |   1 | 2024-02-20 | ongoing     |
  | VVELOX    |   1 | 2024-02-20 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
