package Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current;

use strict;
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-01'; # DATE
our $DIST = 'Acme-CPANAuthorsBundle-CPAN-Streaks'; # DIST
our $VERSION = '20240101.0'; # VERSION

use Acme::CPANAuthors::Register (
    'PERLANCAR' => '',
    'ETHER' => '',
    'PEVANS' => '',
    'SKIM' => '',
    'KIMOTO' => '',
    'BDFOY' => '',
    'DERF' => '',
    'RRWO' => '',
    'PACMAN' => '',
    'JV' => '',
    'MIKKOI' => '',
    'AAHAZRED' => '',
    'BLIAKO' => '',
    'BWEST' => '',
    'DART' => '',
    'DRCLAW' => '',
    'GENE' => '',
    'INGY' => '',
    'KUERBIS' => '',
    'PJACKLAM' => '',
    'YOUPONG' => '',
    'BINGOS' => '',
    'BODOLFO' => '',
    'JMATES' => '',
    'MRDVT' => '',
    'VKON' => '',
    'AJNN' => '',
    'ASPOSE' => '',
    'AVERKIOS' => '',
    'BARTL' => '',
    'BLAINEM' => '',
    'BOOK' => '',
    'BRTASTIC' => '',
    'CCELSO' => '',
    'DAMI' => '',
    'DAVECROSS' => '',
    'DEPESZ' => '',
    'DROLSKY' => '',
    'EXODIST' => '',
    'GUIMARD' => '',
    'JKSTILL' => '',
    'JMCNAMARA' => '',
    'MATHIAS' => '',
    'MHASCH' => '',
    'MRUEDA' => '',
    'NLNETLABS' => '',
    'RHESA' => '',
    'RJET' => '',
    'RMBARKER' => '',
    'SHLOMIF' => '',
    'SZABGAB' => '',
    'TANIGUCHI' => '',
    'TEAM' => '',
    'TODDR' => '',
    'VVELOX' => '',
    'BPSCHUCK' => '',
    'GBROWN' => '',
    'JGNI' => '',
    'SKAJI' => '',
    'UTASHIRO' => '',
);


1;
# ABSTRACT: Authors with ongoing weekly releases streak (do a release every week)

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current - Authors with ongoing weekly releases streak (do a release every week)

=head1 VERSION

This document describes version 20240101.0 of Acme::CPANAuthors::CPAN::Streaks::WeeklyReleases::Current (from Perl distribution Acme-CPANAuthorsBundle-CPAN-Streaks), released on 2024-01-01.

=head1 SYNOPSIS

=head1 DESCRIPTION

Current standings (as of 2024-01-01, produced by L<cpan-streaks>):

  +-----------+-----+------------+-------------+
  | author    | len | start_date | status      |
  +-----------+-----+------------+-------------+
  | PERLANCAR | 489 | 2014-08-24 | ongoing     |
  | ETHER     |  94 | 2022-03-20 | ongoing     |
  | PEVANS    |  27 | 2023-07-02 | ongoing     |
  | SKIM      |  11 | 2023-10-15 | might-break |
  | KIMOTO    |  10 | 2023-10-22 | might-break |
  | BDFOY     |   9 | 2023-10-29 | might-break |
  | DERF      |   9 | 2023-10-29 | might-break |
  | RRWO      |   6 | 2023-11-19 | might-break |
  | PACMAN    |   5 | 2023-11-26 | might-break |
  | JV        |   4 | 2023-12-10 | ongoing     |
  | MIKKOI    |   3 | 2023-12-17 | ongoing     |
  | AAHAZRED  |   2 | 2023-12-17 | might-break |
  | BLIAKO    |   2 | 2023-12-17 | might-break |
  | BWEST     |   2 | 2023-12-17 | might-break |
  | DART      |   2 | 2023-12-17 | might-break |
  | DRCLAW    |   2 | 2023-12-17 | might-break |
  | GENE      |   2 | 2023-12-17 | might-break |
  | INGY      |   2 | 2023-12-17 | might-break |
  | KUERBIS   |   2 | 2023-12-17 | might-break |
  | PJACKLAM  |   2 | 2023-12-17 | might-break |
  | YOUPONG   |   2 | 2023-12-17 | might-break |
  | BINGOS    |   2 | 2023-12-24 | ongoing     |
  | BODOLFO   |   2 | 2023-12-24 | ongoing     |
  | JMATES    |   2 | 2023-12-24 | ongoing     |
  | MRDVT     |   2 | 2023-12-24 | ongoing     |
  | VKON      |   2 | 2023-12-24 | ongoing     |
  | AJNN      |   1 | 2023-12-24 | might-break |
  | ASPOSE    |   1 | 2023-12-24 | might-break |
  | AVERKIOS  |   1 | 2023-12-24 | might-break |
  | BARTL     |   1 | 2023-12-24 | might-break |
  | BLAINEM   |   1 | 2023-12-24 | might-break |
  | BOOK      |   1 | 2023-12-24 | might-break |
  | BRTASTIC  |   1 | 2023-12-24 | might-break |
  | CCELSO    |   1 | 2023-12-24 | might-break |
  | DAMI      |   1 | 2023-12-24 | might-break |
  | DAVECROSS |   1 | 2023-12-24 | might-break |
  | DEPESZ    |   1 | 2023-12-24 | might-break |
  | DROLSKY   |   1 | 2023-12-24 | might-break |
  | EXODIST   |   1 | 2023-12-24 | might-break |
  | GUIMARD   |   1 | 2023-12-24 | might-break |
  | JKSTILL   |   1 | 2023-12-24 | might-break |
  | JMCNAMARA |   1 | 2023-12-24 | might-break |
  | MATHIAS   |   1 | 2023-12-24 | might-break |
  | MHASCH    |   1 | 2023-12-24 | might-break |
  | MRUEDA    |   1 | 2023-12-24 | might-break |
  | NLNETLABS |   1 | 2023-12-24 | might-break |
  | RHESA     |   1 | 2023-12-24 | might-break |
  | RJET      |   1 | 2023-12-24 | might-break |
  | RMBARKER  |   1 | 2023-12-24 | might-break |
  | SHLOMIF   |   1 | 2023-12-24 | might-break |
  | SZABGAB   |   1 | 2023-12-24 | might-break |
  | TANIGUCHI |   1 | 2023-12-24 | might-break |
  | TEAM      |   1 | 2023-12-24 | might-break |
  | TODDR     |   1 | 2023-12-24 | might-break |
  | VVELOX    |   1 | 2023-12-24 | might-break |
  | BPSCHUCK  |   1 | 2023-12-31 | ongoing     |
  | GBROWN    |   1 | 2023-12-31 | ongoing     |
  | JGNI      |   1 | 2023-12-31 | ongoing     |
  | SKAJI     |   1 | 2023-12-31 | ongoing     |
  | UTASHIRO  |   1 | 2023-12-31 | ongoing     |
  +-----------+-----+------------+-------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthorsBundle-CPAN-Streaks>.

=head1 SEE ALSO

L<Acme::CPANAuthors>

CPAN Regulars Boards, L<http://cpan.io/board/once-a/>, which as of this writing,
has some input data missing and thus produces some incorrect results.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024, 2023 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthorsBundle-CPAN-Streaks>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
