package Acme::CPANAuthors::CPAN::TopDepended::ByOthers;

our $DATE = '2016-10-14'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

use Acme::CPANAuthors::Register (
    "RJBS"      => "Ricardo SIGNES",                        #  44535
    "BINGOS"    => "Chris Williams",                        #  25356
    "EXODIST"   => "Chad Granum",                           #  21822
    "ETHER"     => "Karen Etheridge",                       #  18154
    "LEONT"     => "Leon Timmermans",                       #   7152
    "DAGOLDEN"  => "David Golden",                          #   6600
    "GBARR"     => "Graham Barr",                           #   4172
    "PEVANS"    => "Paul Evans",                            #   3829
    "NEILB"     => "Neil Bowers",                           #   3135
    "GAAS"      => "Gisle Aas",                             #   2951
    "DROLSKY"   => "Dave Rolsky",                           #   2770
    "SMUELLER"  => "Steffen Mueller",                       #   2377
    "TODDR"     => "Todd Rinaldo",                          #   2375
    "MIYAGAWA"  => "Tatsuhiko Miyagawa",                    #   2099
    "TOKUHIROM" => "Tokuhiro Matsuno''<xmp>",               #   1938
    "CORION"    => "Max Maischein",                         #   1486
    "REHSACK"   => "Jens Rehsack",                          #   1449
    "BARBIE"    => "Barbie",                                #   1388
    "ISHIGAKI"  => "Kenichi Ishigaki",                      #   1280
    "MLEHMANN"  => "Marc A. Lehmann",                       #   1266
    "ADAMK"     => "Adam Kennedy",                          #   1253
    "TOBYINK"   => "Toby Inkster",                          #   1179
    "RIBASUSHI" => "Peter Rabbitson",                       #   1115
    "JJNAPIORK" => "John Napiorkowski",                     #   1107
    "HAARG"     => "Graham Knop",                           #   1098
    "SHLOMIF"   => "Shlomi Fish",                           #    988
    "DANKOGAI"  => "Dan Kogai",                             #    983
    "BOBTFISH"  => "Tomas Doran",                           #    964
    "JV"        => "Johan Vromans",                         #    937
    "TIMB"      => "Tim Bunce",                             #    931
    "TINITA"    => "Tina Muller",                           #    923
    "JHI"       => "Jarkko Hietaniemi",                     #    858
    "SRI"       => "Sebastian Riedel",                      #    853
    "PLICEASE"  => "Graham Ollis",                          #    831
    "RICHE"     => "Richard Elberger",                      #    821
    "KENTNL"    => "Kent Fredric",                          #    805
    "RCAPUTO"   => "Rocco Caputo",                          #    785
    "DOHERTY"   => "Mike Doherty",                          #    752
    "APOCAL"    => "Apocalypse",                            #    716
    "KWILLIAMS" => "Ken Williams",                          #    681
    "KASEI"     => "Marty Pauley",                          #    679
    "CHORNY"    => "Alexandr Ciornii",                      #    675
    "SYOHEX"    => "Syohei Yoshida",                        #    666
    "OVID"      => "Curtis 'Ovid' Poe",                     #    652
    "ABW"       => "Andy Wardley",                          #    651
    "MAREKR"    => "Marek Rouchal",                         #    637
    "INGY"      => "Ingy dot Net",                          #    621
    "URI"       => "Uri Guttman",                           #    611
    "MSCHILLI"  => "Michael Schilli",                       #    602
    "FREW"      => "Arthur Axel 'fREW' Schmidt",            #    577


);

1;
# ABSTRACT: Authors with the largest number of other authors' distributions depending on one of his/her modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::TopDepended::ByOthers - Authors with the largest number of other authors' distributions depending on one of his/her modules

=head1 VERSION

This document describes version 0.001 of Acme::CPANAuthors::CPAN::TopDepended::ByOthers (from Perl distribution Acme-CPANAuthors-CPAN-TopDepended-ByOthers), released on 2016-10-14.

=head1 SYNOPSIS

   use Acme::CPANAuthors;
   use Acme::CPANAuthors::TopDepended::ByOthers;

   my $authors = Acme::CPANAuthors->new('CPAN::TopDepended::ByOthers');

   my $number   = $authors->count;
   my @ids      = $authors->id;
   my @distros  = $authors->distributions('RJBS');
   my $url      = $authors->avatar_url('RJBS');
   my $kwalitee = $authors->kwalitee('RJBS');

=head1 DESCRIPTION

This module, like L<Acme::CPANAuthors::CPAN::TopDepended>, lists 50 CPAN authors
with the largest number of distributions directly depending to one of his/her
modules. The difference is, only distributions by other authors are counted.
This in some cases might be a better indication of how "depended upon" an author
is, as some authors might have modules that are mostly depended by his/her own
distributions.

This list is produced by querying a local mini CPAN mirror using this command:

except that only distributions

 % lcpan authors-by-rdep-count --exclude-same-author | head -n 50

Statistics of the CPAN mirror:

 +---------------------+----------------------+
 | key                 | value                |
 +---------------------+----------------------+
 | cpan                | /home/s1/cpan        |
 | index_name          | index.db             |
 | last_index_time     | 2016-10-14T11:06:26Z |
 | raw_last_index_time | 1476443186           |
 +---------------------+----------------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthors-CPAN-TopDepended-ByOthers>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthors-CPAN-TopDepended-ByOthers>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthors-CPAN-TopDepended-ByOthers>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANAuthors>

L<Acme::CPANAuthors::CPAN::TopDepended>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
