package Acme::CPANAuthors::CPAN::TopDepended;

our $DATE = '2016-10-14'; # DATE
our $VERSION = '0.002'; # VERSION

use strict;
use warnings;

use Acme::CPANAuthors::Register (
    "EXODIST"   => "Chad Granum",                           #  18217
    "BINGOS"    => "Chris Williams",                        #  16161
    "RJBS"      => "Ricardo SIGNES",                        #  11380
    "ETHER"     => "Karen Etheridge",                       #   8995
    "LEONT"     => "Leon Timmermans",                       #   5630
    "DAGOLDEN"  => "David Golden",                          #   3942
    "GBARR"     => "Graham Barr",                           #   3625
    "PEVANS"    => "Paul Evans",                            #   3281
    "NEILB"     => "Neil Bowers",                           #   2951
    "GAAS"      => "Gisle Aas",                             #   2286
    "TODDR"     => "Todd Rinaldo",                          #   2227
    "SMUELLER"  => "Steffen Mueller",                       #   2166
    "DROLSKY"   => "Dave Rolsky",                           #   2114
    "CORION"    => "Max Maischein",                         #   1460
    "BARBIE"    => "Barbie",                                #   1407
    "TOKUHIROM" => "Tokuhiro Matsuno''<xmp>",               #   1283
    "REHSACK"   => "Jens Rehsack",                          #   1262
    "ADAMK"     => "Adam Kennedy",                          #   1223
    "ISHIGAKI"  => "Kenichi Ishigaki",                      #   1212
    "MIYAGAWA"  => "Tatsuhiko Miyagawa",                    #   1117
    "MLEHMANN"  => "Marc A. Lehmann",                       #    961
    "PERLANCAR" => "perlancar",                             #    951
    "DANKOGAI"  => "Dan Kogai",                             #    928
    "HAARG"     => "Graham Knop",                           #    912
    "JV"        => "Johan Vromans",                         #    902
    "RIBASUSHI" => "Peter Rabbitson",                       #    879
    "SHLOMIF"   => "Shlomi Fish",                           #    872
    "TIMB"      => "Tim Bunce",                             #    849
    "TOBYINK"   => "Toby Inkster",                          #    834
    "TINITA"    => "Tina Muller",                           #    824
    "BOBTFISH"  => "Tomas Doran",                           #    811
    "JHI"       => "Jarkko Hietaniemi",                     #    810
    "RICHE"     => "Richard Elberger",                      #    754
    "PLICEASE"  => "Graham Ollis",                          #    735
    "KASEI"     => "Marty Pauley",                          #    662
    "CHORNY"    => "Alexandr Ciornii",                      #    645
    "OVID"      => "Curtis 'Ovid' Poe",                     #    631
    "JJNAPIORK" => "John Napiorkowski",                     #    618
    "KWILLIAMS" => "Ken Williams",                          #    614
    "INGY"      => "Ingy dot Net",                          #    599
    "SRI"       => "Sebastian Riedel",                      #    596
    "MSCHILLI"  => "Michael Schilli",                       #    593
    "URI"       => "Uri Guttman",                           #    592
    "MAREKR"    => "Marek Rouchal",                         #    574
    "SYOHEX"    => "Syohei Yoshida",                        #    549
    "FREW"      => "Arthur Axel 'fREW' Schmidt",            #    540
    "ZEFRAM"    => "Andrew Main (Zefram)",                  #    532
    "ABW"       => "Andy Wardley",                          #    525
    "KENTNL"    => "Kent Fredric",                          #    524
    "AMS"       => "Abhijit Menon-Sen",                     #    507


);

1;
# ABSTRACT: Authors with the largest number of distributions depending on one of his/her modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::TopDepended - Authors with the largest number of distributions depending on one of his/her modules

=head1 VERSION

This document describes version 0.002 of Acme::CPANAuthors::CPAN::TopDepended (from Perl distribution Acme-CPANAuthors-CPAN-TopDepended), released on 2016-10-14.

=head1 SYNOPSIS

   use Acme::CPANAuthors;
   use Acme::CPANAuthors::TopDepended;

   my $authors = Acme::CPANAuthors->new('CPAN::TopDepended');

   my $number   = $authors->count;
   my @ids      = $authors->id;
   my @distros  = $authors->distributions('RJBS');
   my $url      = $authors->avatar_url('RJBS');
   my $kwalitee = $authors->kwalitee('RJBS');

=head1 DESCRIPTION

This module lists 50 CPAN authors with the largest number of distributions
directly depending to one of his/her modules. This list is produced by querying
a local mini CPAN mirror using this command:

 % lcpan authors-by-rdep-count | head -n 50

Statistics of the CPAN mirror:

 +---------------------+----------------------+
 | key                 | value                |
 +---------------------+----------------------+
 | cpan                | /home/s1/cpan        |
 | index_name          | index.db             |
 | last_index_time     | 2016-10-14T11:06:26Z |
 | raw_last_index_time | 1476443186           |
 +---------------------+----------------------+

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthors-CPAN-TopDepended>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthors-CPAN-TopDepended>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthors-CPAN-TopDepended>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANAuthors>

L<Acme::CPANAuthors::CPAN::TopDepended::ByOthers>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
