package Acme::CPANAuthors::CPAN::TopDepended;

our $DATE = '2016-10-14'; # DATE
our $VERSION = '0.001'; # VERSION

use strict;
use warnings;

use Acme::CPANAuthors::Register (
    "RJBS"      => "Ricardo SIGNES",                        #  46056
    "BINGOS"    => "Chris Williams",                        #  25888
    "ETHER"     => "Karen Etheridge",                       #  24110
    "EXODIST"   => "Chad Granum",                           #  21927
    "LEONT"     => "Leon Timmermans",                       #   7258
    "DAGOLDEN"  => "David Golden",                          #   7223
    "PEVANS"    => "Paul Evans",                            #   4207
    "GBARR"     => "Graham Barr",                           #   4175
    "PERLANCAR" => "perlancar",                             #   3437
    "NEILB"     => "Neil Bowers",                           #   3166
    "DROLSKY"   => "Dave Rolsky",                           #   2979
    "GAAS"      => "Gisle Aas",                             #   2962
    "SMUELLER"  => "Steffen Mueller",                       #   2516
    "TODDR"     => "Todd Rinaldo",                          #   2380
    "MIYAGAWA"  => "Tatsuhiko Miyagawa",                    #   2216
    "TOKUHIROM" => "Tokuhiro Matsuno''<xmp>",               #   2207
    "BARBIE"    => "Barbie",                                #   1748
    "ADAMK"     => "Adam Kennedy",                          #   1596
    "TOBYINK"   => "Toby Inkster",                          #   1568
    "REHSACK"   => "Jens Rehsack",                          #   1501
    "CORION"    => "Max Maischein",                         #   1499
    "MLEHMANN"  => "Marc A. Lehmann",                       #   1391
    "ISHIGAKI"  => "Kenichi Ishigaki",                      #   1362
    "JJNAPIORK" => "John Napiorkowski",                     #   1196
    "RIBASUSHI" => "Peter Rabbitson",                       #   1117
    "HAARG"     => "Graham Knop",                           #   1114
    "SHLOMIF"   => "Shlomi Fish",                           #   1100
    "PLICEASE"  => "Graham Ollis",                          #   1038
    "BOBTFISH"  => "Tomas Doran",                           #   1016
    "KENTNL"    => "Kent Fredric",                          #    999
    "DANKOGAI"  => "Dan Kogai",                             #    987
    "JV"        => "Johan Vromans",                         #    949
    "TIMB"      => "Tim Bunce",                             #    939
    "TINITA"    => "Tina Muller",                           #    934
    "JHI"       => "Jarkko Hietaniemi",                     #    860
    "SRI"       => "Sebastian Riedel",                      #    855
    "RICHE"     => "Richard Elberger",                      #    821
    "RCAPUTO"   => "Rocco Caputo",                          #    814
    "INGY"      => "Ingy dot Net",                          #    777
    "DOHERTY"   => "Mike Doherty",                          #    773
    "APOCAL"    => "Apocalypse",                            #    745
    "KWILLIAMS" => "Ken Williams",                          #    684
    "CHORNY"    => "Alexandr Ciornii",                      #    680
    "KASEI"     => "Marty Pauley",                          #    679
    "ZEFRAM"    => "Andrew Main (Zefram)",                  #    679
    "SYOHEX"    => "Syohei Yoshida",                        #    676
    "MSCHILLI"  => "Michael Schilli",                       #    674
    "OVID"      => "Curtis 'Ovid' Poe",                     #    665
    "ABW"       => "Andy Wardley",                          #    655
    "MAREKR"    => "Marek Rouchal",                         #    638


);

1;
# ABSTRACT: Authors with the largest number of distributions depending on one of his/her modules

__END__

=pod

=encoding UTF-8

=head1 NAME

Acme::CPANAuthors::CPAN::TopDepended - Authors with the largest number of distributions depending on one of his/her modules

=head1 VERSION

This document describes version 0.001 of Acme::CPANAuthors::CPAN::TopDepended (from Perl distribution Acme-CPANAuthors-CPAN-TopDepended), released on 2016-10-14.

=head1 SYNOPSIS

   use Acme::CPANAuthors;
   use Acme::CPANAuthors::TopDepended;

   my $authors = Acme::CPANAuthors->new('CPAN::TopDepended');

   my $number   = $authors->count;
   my @ids      = $authors->id;
   my @distros  = $authors->distributions('RJBS');
   my $url      = $authors->avatar_url('RJBS');
   my $kwalitee = $authors->kwalitee('RJBS');

=head1 DESCRIPTION

This module lists 50 CPAN authors with the largest number of distributions
directly depending to one of his/her modules. This list is produced by querying
a local mini CPAN mirror using this command:

 % lcpan authors-by-rdep-count | head -n 50

Statistics of the CPAN mirror:

 cpan	/home/s1/cpan
 index_name	index.db
 last_index_time	2016-10-14T11:06:26Z
 raw_last_index_time	1476443186

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Acme-CPANAuthors-CPAN-TopDepended>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Acme-CPANAuthors-CPAN-TopDepended>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Acme-CPANAuthors-CPAN-TopDepended>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<Acme::CPANAuthors>

L<Acme::CPANAuthors::CPAN::TopDepended::ByOthers>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
