#!/usr/bin/env perl
 
use strict;
use warnings;
 
BEGIN{
  $ENV{MOJO_NO_IPV6} = $ENV{MOJO_POLL} = 1 ;
  $ENV{MOJO_APP} = undef; # 
}
use Test::More tests => 3;
use Test::Mojo;
 
use Mojolicious::Lite;
plugin 'SemanticUIPageNavigator';
get( "samples" => sub(){
    my $self = shift;
    $self->render( text => $self->page_navigator( 1, 18, {round => 2} ) . "\n"  );
  } );
 
 
my $t = Test::Mojo->new(  );
$t->get_ok( "/samples" )
  ->status_is( 200 )
  ->content_is(<<EOF);
<div id="pagination_outer" style="margin: 10px auto; text-align: center"><div class="ui pagination menu" id="pagination_inner"><a class="item" href="/samples?p=1" id="semantic_pagination_1">首页</a><a class="item" href="/samples?p=0" id="semantic_pagination_2">上一页</a><a class="active teal item" href="/samples?p=1" id="se-pa-a1">1</a><a class="item" href="/samples?p=2" id="se-pa-a2">2</a><a class="item" href="/samples?p=3" id="se-pa-a3">3</a><a class="item" href="/samples?p=4" id="se-pa-a4">4</a><a class="item" href="/samples?p=5" id="se-pa-a5">5</a><a class="item" href="/samples?p=6" id="se-pa-a6">6</a><a class="item" id="se-pa-a">..</a><a class="item" href="/samples?p=17" id="se-pa-a17">17</a><a class="item" href="/samples?p=18" id="se-pa-a18">18</a><a class="item" href="/samples?p=2" id="last1">下一页</a><a class="item" href="/samples?p=18" id="last2">末页</a></div></div>
EOF
1;
