package JIRA::REST::Class::Issue::Changelog::Change;
use base qw( JIRA::REST::Class::Abstract );
use strict;
use warnings;
use v5.10;

our $VERSION = '0.01'; # TRIAL

# ABSTRACT: A helper class for C<JIRA::REST::Class> that represents an individual change to a JIRA issue as an object.

__PACKAGE__->mk_ro_accessors(qw/ author created /);
__PACKAGE__->mk_data_ro_accessors(qw/ id /);
__PACKAGE__->mk_contextual_ro_accessors(qw/ items /);

sub init {
    my $self = shift;
    $self->SUPER::init(@_);

    # make user object
    $self->populate_scalar_data('author', 'user', 'author');

    # make date object
    $self->populate_date_data('created', 'created');

    # make list of changed items
    $self->populate_list_data('items', 'changeitem', 'items');
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

JIRA::REST::Class::Issue::Changelog::Change - A helper class for C<JIRA::REST::Class> that represents an individual change to a JIRA issue as an object.

=head1 VERSION

version 0.01

=head1 READ-ONLY ACCESSORS

=head2 B<author>
Returns the author of a JIRA issue's change as a C<JIRA::REST::Class::User> object.

=head2 B<created>
Returns the creation time of a JIRA issue's change as a C<DateTime> object.

=head2 B<id>
Returns the id of a JIRA issue's change.

=head2 B<items>
Returns the list of items modified by a JIRA issue's change as a list of C<JIRA::REST::Class::Issue::Changelog::Change::Item> objects.

=head1 AUTHOR

Packy Anderson <packy@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Packy Anderson.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
