use strict;
use warnings;

package Mojolicious::Plugin::Web::Auth::Site::Contrib::Spotify;
$Mojolicious::Plugin::Web::Auth::Site::Contrib::Spotify::VERSION = '0.000001';
use Mojo::Base qw/Mojolicious::Plugin::Web::Auth::OAuth2/;

has user_info        => 1;
has authorize_url    => 'https://accounts.spotify.com/authorize';
has access_token_url => 'https://accounts.spotify.com/api/token';
has user_info_url    => 'https://api.spotify.com/v1/me';
has response_type    => 'code';

sub moniker {'spotify'}

1;

# ABSTRACT: Spotify OAuth Plugin for Mojolicious::Plugin::Web::Auth

__END__

=pod

=encoding UTF-8

=head1 NAME

Mojolicious::Plugin::Web::Auth::Site::Contrib::Spotify - Spotify OAuth Plugin for Mojolicious::Plugin::Web::Auth

=head1 VERSION

version 0.000001

=head1 SYNOPSIS

    # Mojolicious
    $self->plugin('Web::Auth',
        module      => 'Contrib::Spotify',
        key         => 'Spotify consumer key',
        secret      => 'Spotify consumer secret',
        on_finished => sub {
            my ( $c, $access_token, $access_secret ) = @_;
            ...
        },
    );

    # Mojolicious::Lite
    plugin 'Web::Auth',
        module      => 'Contrib::Spotify',
        key         => 'Spotify consumer key',
        secret      => 'Spotify consumer secret',
        on_finished => sub {
            my ( $c, $access_token, $access_secret ) = @_;
            ...
        };


    # default authentication endpoint: /auth/spotify/authenticate
    # default callback endpoint: /auth/spotify/callback

=head1 AUTHOR

Olaf Alders <olaf@wundercounter.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Olaf Alders.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
