/*	$Id: SEC.xs 1615 2018-01-15 14:25:45Z willem $	*/

#define PERL_NO_GET_CONTEXT

#ifdef __cplusplus
extern "C" {
#endif

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include <openssl/bn.h>
#include <openssl/dsa.h>
#include <openssl/objects.h>
#include <openssl/rsa.h>

#ifdef __cplusplus
}
#endif

static int get_NID(const char *id)
{
	if ( strcmp(id, "SHA512") == 0 ) return NID_sha512;
	if ( strcmp(id, "SHA256") == 0 ) return NID_sha256;
	if ( strcmp(id, "SHA1") == 0 )	 return NID_sha1;
	if ( strcmp(id, "MD5") == 0 )	 return NID_md5;
	croak("Unknown algorithm");
}

#if OPENSSL_VERSION_NUMBER < 0x10100000L
int DSA_set0_pqg(DSA *d, BIGNUM *p, BIGNUM *q, BIGNUM *g)
{
	BN_free(d->p);
	d->p = p;
	BN_free(d->q);
	d->q = q;
	BN_free(d->g);
	d->g = g;
	return 1;
}

int DSA_set0_key(DSA *d, BIGNUM *pub_key, BIGNUM *priv_key)
{
	BN_free(d->pub_key);
	d->pub_key = pub_key;

	if (priv_key != NULL) {
		BN_clear_free(d->priv_key);
		d->priv_key = priv_key;
	}

	return 1;
}

void DSA_SIG_get0(const DSA_SIG *sig, const BIGNUM **pr, const BIGNUM **ps)
{
	if (pr != NULL) *pr = sig->r;
	if (ps != NULL) *ps = sig->s;
}

int DSA_SIG_set0(DSA_SIG *sig, BIGNUM *r, BIGNUM *s)
{
	BN_clear_free(sig->r);
	sig->r = r;
	BN_clear_free(sig->s);
	sig->s = s;
	return 1;
}

int RSA_set0_key(RSA *r, BIGNUM *n, BIGNUM *e, BIGNUM *d)
{
	BN_free(r->n);
	r->n = n;
	BN_free(r->e);
	r->e = e;
	BN_free(r->d);
	r->d = d;
	return 1;
}

int RSA_set0_factors(RSA *r, BIGNUM *p, BIGNUM *q)
{
	BN_free(r->p);
	r->p = p;
	BN_free(r->q);
	r->q = q;
	return 1;
}

#endif


MODULE = Net::DNS::SEC		PACKAGE = Net::DNS::SEC::libcrypto

PROTOTYPES: DISABLE

SV*
VERSION(void)
    CODE:
	RETVAL = newSV(0);
	sv_setpvf(RETVAL, "%8.8lx", OPENSSL_VERSION_NUMBER);
    OUTPUT:
	RETVAL


####	DSA	####

DSA*
DSA_new()

void
DSA_free(DSA *dsa)

int
DSA_set0_pqg(DSA *d, SV *p_SV, SV *q_SV, SV *g_SV)
    PREINIT:
	BIGNUM* p;
	BIGNUM* q;
	BIGNUM* g;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( p_SV, len );
	p = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( q_SV, len );
	q = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( g_SV, len );
	g = BN_bin2bn( bin, len, NULL );
	RETVAL = DSA_set0_pqg( d, p, q, g );
    OUTPUT:
	RETVAL

void
DSA_set_priv_key(DSA *dsa, SV *key_SV)
    PREINIT:
	BIGNUM *private_key;
	BIGNUM *public_key;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( key_SV, len );
	private_key = BN_bin2bn( bin, len, NULL );
	public_key = BN_new();
	if ( !DSA_set0_key( dsa, public_key, private_key ) ) {
		BN_clear_free(private_key);
		BN_free(public_key);
		croak("Could not set private key");
	}

void
DSA_set_pub_key(DSA *dsa, SV *key_SV)
    PREINIT:
	BIGNUM *public_key;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( key_SV, len );
	public_key = BN_bin2bn( bin, len, NULL );
	if ( !DSA_set0_key( dsa, public_key, NULL ) ) {
		BN_free(public_key);
		croak("Could not set public key");
	}


DSA_SIG*
DSA_do_sign(SV *dgst, DSA *dsa)
    PREINIT:
	const unsigned char *bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( dgst, len );
	RETVAL = DSA_do_sign( bin, (int)len, dsa );
    OUTPUT:
	RETVAL

int
DSA_do_verify(SV *dgst, DSA_SIG *sig, DSA *dsa)
    PREINIT:
	const unsigned char *bin;
	STRLEN	len;
    CODE:
	bin = (unsigned char*) SvPV( dgst, len );
	RETVAL = DSA_do_verify( bin, (int)len, sig, dsa );
    OUTPUT:
	RETVAL


DSA_SIG*
DSA_SIG_new()

void
DSA_SIG_free(DSA_SIG *dsa_sig)

int
DSA_SIG_set0(DSA_SIG *sig, SV *r_SV, SV *s_SV)
    PREINIT:
	BIGNUM* r;
	BIGNUM* s;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( r_SV, len );
	r = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( s_SV, len );
	s = BN_bin2bn( bin, len, NULL );
	RETVAL = DSA_SIG_set0( sig, r, s );
    OUTPUT:
	RETVAL

SV *
DSA_SIG_get_r(DSA_SIG *dsa_sig)
    PREINIT:
	const BIGNUM *bn;
	unsigned char *bin;
	int len;
    CODE:
	DSA_SIG_get0( dsa_sig, &bn, NULL );
	bin = malloc( sizeof(char) * 128 );
	len = BN_bn2bin( bn, bin );
	RETVAL = newSVpvn( (const char *)bin, len );
	free(bin);
    OUTPUT:
	RETVAL

SV *
DSA_SIG_get_s(DSA_SIG *dsa_sig)
    PREINIT:
	const BIGNUM *bn;
	unsigned char *bin;
	int len;
    CODE:
	DSA_SIG_get0( dsa_sig, NULL, &bn );
	bin = malloc( sizeof(char) * 128 );
	len = BN_bn2bin( bn, bin );
	RETVAL = newSVpvn( (const char *)bin, len );
	free(bin);
    OUTPUT:
	RETVAL


####	RSA	####

RSA*
RSA_new()

void
RSA_free(RSA *dsa)

int
RSA_set0_factors(RSA *r, SV *p_SV, SV *q_SV)
    PREINIT:
	BIGNUM* p;
	BIGNUM* q;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( p_SV, len );
	p = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( q_SV, len );
	q = BN_bin2bn( bin, len, NULL );
	RETVAL = RSA_set0_factors( r, p, q );
    OUTPUT:
	RETVAL

int
RSA_set0_key(RSA *r, SV *n_SV, SV *e_SV, SV *d_SV)
    PREINIT:
	BIGNUM* n;
	BIGNUM* e;
	BIGNUM* d;
	unsigned char* bin;
	STRLEN len;
    CODE:
	bin = (unsigned char*) SvPV( n_SV, len );
	n = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( e_SV, len );
	e = BN_bin2bn( bin, len, NULL );
	bin = (unsigned char*) SvPV( d_SV, len );
	d = BN_bin2bn( bin, len, NULL );
	RETVAL = RSA_set0_key( r, n, e, d );
    OUTPUT:
	RETVAL

SV*
RSA_sign(int type, SV *msg, RSA *rsa)
    PREINIT:
	const unsigned char *m;
	STRLEN	mlen;
	char *s;
	unsigned int slen;
    CODE:
	m = (unsigned char*) SvPV( msg, mlen );
	s = malloc( sizeof(char) * 128 );
	RSA_sign( type, m, mlen, (unsigned char*) s, &slen, rsa );
	RETVAL = newSVpvn( s, slen );
	free(s);
    OUTPUT:
	RETVAL

int
RSA_verify(int type, SV *msg, SV *sig, RSA *rsa)
    PREINIT:
	const unsigned char *m;
	STRLEN	mlen;
	const unsigned char *s;
	STRLEN	slen;
    CODE:
	m = (unsigned char*) SvPV( msg, mlen );
	s = (unsigned char*) SvPV( sig, slen );
	if (RSA_size(rsa) < slen) { croak("Signature longer than key"); }
	RETVAL = RSA_verify( type, m, (int)mlen, s, slen, rsa );
    OUTPUT:
	RETVAL

int
get_NID(char *id)

####################

