# $Id: Makefile.PL 51 2005-12-14 16:59:25Z nanardon $

# use 5.008;
use ExtUtils::MakeMaker;
use Getopt::Long;

GetOptions(
    'rpmversion=s' => \$rpmv,
    'rebuildh' => \my $rebh,
);

my $rpmv ||= (`rpm --version` =~ /([\d\.]+)/)[0];
open($FH, "> rpmversion.h") or die "Can't open rpmversion.h";
print $FH "/* File generated by Mafile.PL\n";
print $FH ' * $Id: Makefile.PL 51 2005-12-14 16:59:25Z nanardon $' ."\n";
print $FH " */\n\n";
print $FH "#ifndef RPMVERSION_H\n#define RPMVERSION_H\n\n";
foreach (qw(
    4.2.0
    4.4.1
    4.4.2
    4.4.3
    4.4.4
    )) {
    if ($rpmv ge $_) {
        $v = $_;
        $v =~ s/\./_/g;
        print $FH "#define RPM$v\n";
    }
}
print $FH "\n#endif\n";
close($FH);
if ($rebh) { exit 0 };

my ($obj, $ldd, $fl) =
    -f '/usr/include/rpmconstant/rpmconstant.h' ?
    ('', '-lrpmconstant', '-DHAVE_RPMCONSTANT') :
    ('rpmconstant.o rpmconstant_internal.o rpmconstanttbl.o', '', '');

sub MY::postamble {
        my $first = <<RPMCONSTTBL;
rpmversion.h:
	\$(PERL) Makefile.PL --rebuildh

rpmconstanttbl.c: Makefile rpmh2tbl
	perl rpmh2tbl /usr/include/rpm/*.h > \$@
RPMCONSTTBL
	# This code is to reduce duplication of files
	# in fact it is only usefull for the maintainers of this module
	# if you get the module from CPAN, those files are allready here
	# if you're building from svn, you need rpmconstant directory
	my $second = "";
	if(-d '../../rpmconstant') {
	 $second = <<RPMCONST
rpmconstant.c: ../../rpmconstant/rpmconstant.c
	cp -a \$< \$@

rpmconstant.h: ../../rpmconstant/rpmconstant.h
	cp -a \$< \$@

rpmconstant_internal.c: ../../rpmconstant/rpmconstant_internal.c
	cp -a \$< \$@

rpmh2tbl: ../../rpmconstant/rpmh2tbl
	cp -a \$< \$@
RPMCONST
	}

	$first . $second
}

WriteMakefile(
    NAME         => 'RPM4',
    VERSION_FROM => '../lib/RPM4.pm',
    OBJECT       => "RPM4.o RPM4sign.o $obj",
    INC	         => '-I/usr/include/rpm',
    LIBS         => "-lrpm -lrpmio -lrpmdb -lrpmbuild -lpopt -lz -lbz2 $ldd",
    'CCFLAGS'    => $fl,
);
