#!/usr/bin/perl

# $Id: 01distribconf.t 57074 2006-08-22 00:40:35Z nanardon $

use strict;
use Test::More;

my @testdpath = qw(
    testdata/test
    testdata/test2
    testdata/test3
);

plan tests => 14 + 17 * scalar(@testdpath);

use_ok('MDV::Distribconf');

{
ok(my $dconf = MDV::Distribconf->new('/dev/null'), "Can get new MDV::Distribconf");
ok(!$dconf->load(), "loading wrong distrib give error");
}

foreach my $path (@testdpath) {
    ok(my $dconf = MDV::Distribconf->new($path), "Can get new MDV::Distribconf");
    ok($dconf->load(), "Can load conf");

    ok(scalar($dconf->listmedia) == 8, "Can list all media");
    ok((grep { $_ eq 'main' } $dconf->listmedia), "list properly media");

    is($dconf->getvalue(undef, 'version'), '2006.0', "Can get global value");
    is($dconf->getvalue('main', 'version'), '2006.0', "Can get global value via media");
    is($dconf->getvalue('main', 'name'), 'main', "Can get default name");
    is($dconf->getvalue('contrib', 'name'), 'Contrib', "Can get media name");

    is($dconf->getpath(undef, 'root'), $path, "Can get root path");
    like($dconf->getpath(undef, 'media_info'), qr!^/*media/media_info/?$!, "Can get media_info path"); # vim color: */ 
    like($dconf->getfullpath(undef, 'media_info'), qr!^/*$path/+media/media_info/?$!, "Can get media_info fullpath"); # vim color: */
    like($dconf->getpath('main', 'path'), qr!^/*media/+main/?$!, "Can get media path"); # vim color: */
    like($dconf->getfullpath('main', 'path'), qr!^/*$path/*media/+main/?$!, "Can get media fullpath"); # vim color: */
    like($dconf->getpath('main', 'hdlist'), qr!^/*media/+media_info/+hdlist_main.cz$!, "Can get media path"); # vim color: */
    like($dconf->getfullpath('main', 'hdlist'), qr!^/*$path/*media/+media_info/+hdlist_main.cz$!, "Can get media fullpath"); # vim color: */
    like($dconf->getmediapath('main', 'hdlist'), qr!^/*media/+main/+media_info/+hdlist.cz$!, "Can get media path"); # vim color: */
    like($dconf->getfullmediapath('main', 'hdlist'), qr!^/*$path/*media/+main/+media_info/+hdlist.cz$!, "Can get media fullpath"); # vim color: */
}

{
ok(my $dconf = MDV::Distribconf->new('not_exists', 1), "Can get new MDV::Distribconf");
$dconf->settree();
like($dconf->getpath(undef, 'media_info'), qr!^/*media/media_info/?$!, "Can get media_info path"); # vim color: */
}
{
ok(my $dconf = MDV::Distribconf->new('not_exists', 1), "Can get new MDV::Distribconf");
$dconf->settree('manDraKE');
like($dconf->getpath(undef, 'media_info'), qr!^/*Mandrake/base/?$!, "Can get media_info path"); # vim color: */
}
{
ok(my $dconf = MDV::Distribconf->new('not_exists', 1), "Can get new MDV::Distribconf");
$dconf->settree({ 
  mediadir => 'mediadir',
  infodir => 'infodir',
});
like($dconf->getpath(undef, 'media_info'), qr!^/*infodir/?$!, "Can get media_info path"); # vim color: */
}

{
    # test for %{} ${} var
    my $dc = MDV::Distribconf->new('testdata/test3');
    $dc->load();
    is(
        $dc->_expand(undef, '${version}'),
        '2006.0',
        'expand works'
    );
    is(
        $dc->_expand('jpackage', '%{name}'),
        'jpackage',
        'expand works'
    );
    is(
        $dc->_expand('jpackage', '${version}'),
        '2006.0',
        'expand works'
    );
    is(
        $dc->_expand(undef, '%{foo}'),
        '%{foo}',
        'expand works'
    );
    is(
        $dc->getvalue('jpackage', 'hdlist'),
        'hdlist_jpackage.cz',
        'getvalue works'
    );
}
